/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.oats.vospace.datamodel;

import it.inaf.oats.vospace.datamodel.NodeProperties;
import java.util.ArrayList;
import java.util.List;
import net.ivoa.xml.vospace.v2.Node;

public class NodeUtils {
    public static String getPathFromRequestURLString(String requestUrlString) {
        String[] split = requestUrlString.split("/nodes/");
        Object path = "/";
        if (split.length == 2) {
            path = (String)path + split[1];
        }
        return path;
    }

    public static String getParentPath(String path) {
        String[] parsedPath = path.split("[/]+");
        if (parsedPath.length < 2 || !parsedPath[0].isEmpty()) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        for (int i = 1; i < parsedPath.length - 1; ++i) {
            sb.append(parsedPath[i]);
            if (i >= parsedPath.length - 2) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    public static List<String> subPathComponents(String path) {
        ArrayList<String> resultList = new ArrayList<String>();
        String[] pathComponents = path.split("[/]+");
        if (pathComponents.length == 0) {
            resultList.add("/");
        } else {
            Object parentPath = "/";
            for (int i = 1; i < pathComponents.length; ++i) {
                parentPath = (String)parentPath + pathComponents[i] + "/";
                resultList.add(((String)parentPath).substring(0, ((String)parentPath).length() - 1));
            }
        }
        return resultList;
    }

    public static boolean checkIfWritable(Node myNode, String userName, List<String> userGroups) {
        List<String> nodeOwner = NodeProperties.getNodePropertyByURI(myNode, "ivo://ivoa.net/vospace/core#creator");
        if (nodeOwner == null || nodeOwner.isEmpty() || !nodeOwner.get(0).equals(userName)) {
            if (userGroups == null || userGroups.isEmpty()) {
                return false;
            }
            List<String> groupWritePropValues = NodeProperties.getNodePropertyByURI(myNode, "ivo://ivoa.net/vospace/core#groupwrite");
            if (groupWritePropValues == null || groupWritePropValues.isEmpty()) {
                return false;
            }
            List<String> nodeGroups = NodeProperties.parsePropertyStringToList(groupWritePropValues.get(0));
            if (nodeGroups.isEmpty() || !nodeGroups.stream().anyMatch(i -> userGroups.contains(i))) {
                return false;
            }
        }
        return true;
    }
}

