/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.oats.vospace.datamodel;

import java.util.List;
import java.util.stream.Collectors;
import net.ivoa.xml.vospace.v2.Node;
import net.ivoa.xml.vospace.v2.Property;

public class NodeProperties {
    public static final String AVAILABLE_SPACE_URI = "ivo://ivoa.net/vospace/core#availableSpace";
    public static final String INITIAL_CREATION_TIME_URI = "ivo://ivoa.net/vospace/core#btime";
    public static final String CONTRIBUTOR_URI = "ivo://ivoa.net/vospace/core#contributor";
    public static final String COVERAGE_URI = "ivo://ivoa.net/vospace/core#coverage";
    public static final String CREATOR_URI = "ivo://ivoa.net/vospace/core#creator";
    public static final String STATUS_CHANGE_TIME_URI = "ivo://ivoa.net/vospace/core#ctime";
    public static final String DATE_URI = "ivo://ivoa.net/vospace/core#date";
    public static final String DESCRIPTION_URI = "ivo://ivoa.net/vospace/core#description";
    public static final String FORMAT_URI = "ivo://ivoa.net/vospace/core#format";
    public static final String GROUP_READ_URI = "ivo://ivoa.net/vospace/core#groupread";
    public static final String GROUP_WRITE_URI = "ivo://ivoa.net/vospace/core#groupwrite";
    public static final String IDENTIFIER_URI = "ivo://ivoa.net/vospace/core#identifier";
    public static final String LANGUAGE_URI = "ivo://ivoa.net/vospace/core#language";
    public static final String CORE_URI = "ivo://ivoa.net/vospace/core#length";
    public static final String MODIFICATION_TIME_URI = "ivo://ivoa.net/vospace/core#mtime";
    public static final String PUBLIC_READ_URI = "ivo://ivoa.net/vospace/core#publicread";
    public static final String PUBLISHER_URI = "ivo://ivoa.net/vospace/core#publisher";
    public static final String QUOTA_URI = "ivo://ivoa.net/vospace/core#quota";
    public static final String RELATED_RESOURCE_URI = "ivo://ivoa.net/vospace/core#relation";
    public static final String RIGHTS_ON_URI = "ivo://ivoa.net/vospace/core#rights";
    public static final String RESOURCE_RELATED_URI = "ivo://ivoa.net/vospace/core#source";
    public static final String SUBJECT_URI = "ivo://ivoa.net/vospace/core#subject";
    public static final String TITLE_URI = "ivo://ivoa.net/vospace/core#title";
    public static final String TYPE_URI = "ivo://ivoa.net/vospace/core#type";

    private NodeProperties() {
    }

    public static String getProperty(Node node, String propertyName) {
        for (Property property : node.getProperties()) {
            if (!property.getUri().equals("ivo://ivoa.net/vospace/core#".concat(propertyName))) continue;
            return property.getValue();
        }
        return null;
    }

    public static List<String> getNodePropertyByURI(Node node, String propertyURI) {
        List<String> propertyList = node.getProperties().stream().filter(i -> i.getUri().equals(propertyURI)).map(i -> i.getValue()).collect(Collectors.toList());
        return propertyList;
    }

    public static List<String> parsePropertyStringToList(String property) {
        String separator = " ";
        String trimmedProperty = property.trim();
        if (trimmedProperty.isEmpty()) {
            return List.of();
        }
        return List.of(trimmedProperty.split(separator));
    }
}

