/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.oats.vospace.datamodel;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Map;
import net.ivoa.xml.uws.v1.JobSummary;
import net.ivoa.xml.vospace.v2.Transfer;

public class JobInfoDeserializer
extends StdDeserializer<JobSummary.JobInfo> {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public JobInfoDeserializer() {
        super(JobSummary.JobInfo.class);
    }

    public JobSummary.JobInfo deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
        Object content = jp.getCodec().readValue(jp, Object.class);
        if (content == null) {
            return null;
        }
        if (!(content instanceof Map)) {
            throw new UnsupportedOperationException("JobInfo contains an instance of " + content.getClass().getCanonicalName());
        }
        Map map = (Map)content;
        if (map.isEmpty()) {
            return null;
        }
        if (map.keySet().size() > 1) {
            throw new UnsupportedOperationException("Multiple keys found in JobInfo content");
        }
        String name = ((String[])map.keySet().toArray(String[]::new))[0];
        JobSummary.JobInfo jobInfo = new JobSummary.JobInfo();
        switch (name) {
            case "transfer": {
                String transferJson = MAPPER.writeValueAsString(map.get(name));
                Transfer transfer = (Transfer)MAPPER.readValue(transferJson, Transfer.class);
                jobInfo.getAny().add(transfer);
                break;
            }
            default: {
                throw new UnsupportedOperationException("JobInfo map key is " + name);
            }
        }
        return jobInfo;
    }
}

