/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.oats.vospace.parent.persistence;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class LinkedServiceDAO {
    private static final Logger LOG = LoggerFactory.getLogger(LinkedServiceDAO.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public LinkedServiceDAO(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public boolean isLinkedServiceUrl(String targetUrl) {
        String sql = " SELECT COUNT(*) > 0\nFROM linked_service\nWHERE ? LIKE service_base_url || '%'";
        return (Boolean)this.jdbcTemplate.query(sql, ps -> ps.setString(1, targetUrl), row -> {
            if (!row.next()) {
                throw new IllegalStateException("Expected one result");
            }
            return row.getBoolean(1);
        });
    }
}

