/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.oats.vospace.exception;

import it.inaf.oats.vospace.exception.VOSpaceFaultEnum;
import it.inaf.oats.vospace.exception.VoSpaceErrorSummarizableException;
import net.ivoa.xml.uws.v1.ErrorSummary;

public class ErrorSummaryFactory {
    public static ErrorSummary newErrorSummary(VOSpaceFaultEnum error, String detailMessage) {
        ErrorSummary result = new ErrorSummary();
        result.setMessage(error.getFaultRepresentation());
        result.setType(error.getType());
        if (detailMessage == null || detailMessage.isBlank()) {
            result.setHasDetail(false);
        } else {
            result.setHasDetail(true);
            result.setDetailMessage(error.getFaultCaptionForDetails() + " " + detailMessage);
        }
        return result;
    }

    public static ErrorSummary newErrorSummary(VOSpaceFaultEnum error) {
        return ErrorSummaryFactory.newErrorSummary(error, null);
    }

    public static ErrorSummary newErrorSummary(VoSpaceErrorSummarizableException e) {
        return ErrorSummaryFactory.newErrorSummary(e.getFault(), e.getDetailMessage());
    }
}

