/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.tapclient.datamodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TAPEntity<T extends TAPEntity>
implements Serializable {
    private static final long serialVersionUID = -5920720569836415636L;
    private final String name;
    private final Map<String, T> children;
    private final Map<String, Object> properties;

    protected TAPEntity(String name) {
        this(name, true);
    }

    protected TAPEntity(String name, boolean hasChildren) {
        this.name = name;
        this.properties = new HashMap<String, Object>();
        this.children = hasChildren ? new HashMap<String, T>() : null;
    }

    public String getName() {
        return this.name;
    }

    public List<T> getChildren() {
        return Collections.unmodifiableList(new ArrayList<T>(this.children.values()));
    }

    public T getChild(String name) {
        return (T)((TAPEntity)this.children.get(name));
    }

    public void addChild(T child) {
        this.children.put(((TAPEntity)child).getName(), child);
    }

    public void addProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }
}

