/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.tapclient;

import it.inaf.ia2.tapclient.QueryResultsParser;
import it.inaf.ia2.tapclient.TAPClient;
import it.inaf.ia2.tapclient.TAPServiceException;
import it.inaf.ia2.tapclient.datamodel.Column;
import it.inaf.ia2.tapclient.datamodel.Schema;
import it.inaf.ia2.tapclient.datamodel.Table;
import it.inaf.ia2.tapclient.datamodel.TapSchema;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TapSchemaLoader {
    private final TAPSchemaResultParser parser;

    public TapSchemaLoader(TAPClient client, String ... columnProperties) {
        this.parser = new TAPSchemaResultParser(client, columnProperties);
    }

    public TapSchema load() throws TAPServiceException {
        this.parser.parseQuery();
        return this.parser.getTapSchema();
    }

    private static class TAPSchemaResultParser
    extends QueryResultsParser {
        private final TapSchema tapSchema = new TapSchema("TAP_SCHEMA");
        private final String[] columnProperties;

        private static String getColumnPropertiesString(String ... columnProperties) {
            if (columnProperties == null || columnProperties.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (String columnProperty : columnProperties) {
                sb.append(", ");
                sb.append(columnProperty);
            }
            return sb.toString();
        }

        public TAPSchemaResultParser(TAPClient client, String ... columnProperties) {
            super(client, String.format("SELECT table_name, column_name%s FROM TAP_SCHEMA.columns", TAPSchemaResultParser.getColumnPropertiesString(columnProperties)));
            this.columnProperties = columnProperties;
        }

        @Override
        public void readMetadataItem(Map<String, Object> rowItem) {
        }

        @Override
        public void readDataRow(List<Object> rowItems) {
            Column column;
            Table table;
            String completeTableName = (String)rowItems.get(0);
            String[] tableNameSplit = completeTableName.split(Pattern.quote("."));
            String schemaName = tableNameSplit[0];
            String tableName = tableNameSplit[1];
            String columnName = (String)rowItems.get(1);
            Schema schema = (Schema)this.tapSchema.getChild(schemaName);
            if (schema == null) {
                schema = new Schema(schemaName);
                this.tapSchema.addChild(schema);
            }
            if ((table = (Table)schema.getChild(tableName)) == null) {
                table = new Table(tableName);
                schema.addChild(table);
            }
            if ((column = (Column)table.getChild(columnName)) == null) {
                column = new Column(columnName);
                table.addChild(column);
            }
            for (int i = 2; i < rowItems.size(); ++i) {
                column.addProperty(this.columnProperties[i - 2], rowItems.get(i));
            }
        }

        public TapSchema getTapSchema() {
            return this.tapSchema;
        }
    }
}

