/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.tapclient;

import it.inaf.ia2.tapclient.JaxbForkJoinWorkerThreadFactory;
import it.inaf.ia2.tapclient.Job;
import it.inaf.ia2.tapclient.JobPhase;
import it.inaf.ia2.tapclient.TAPServiceException;
import it.inaf.ia2.tapclient.TapSchemaLoader;
import it.inaf.ia2.tapclient.datamodel.TapSchema;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.bind.JAXB;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class TAPClient {
    public static final String FORMAT_VOTABLE_XML = "application/x-votable+xml";
    public static final String FORMAT_VOTABLE_FITS = "application/x-votable+xml;serialization=FITS";
    public static final String FORMAT_VOTABLE_BINARY2 = "application/x-votable+xml;serialization=BINARY2";
    public static final String FORMAT_VOTABLE_TABLEDATA = "application/x-votable+xml;serialization=TABLEDATA";
    public static final String FORMAT_CSV = "text/csv";
    public static final String FORMAT_TSV = "text/tab-separated-values";
    public static final String FORMAT_TEXT = "text/plain";
    public static final String FORMAT_JSON = "application/json";
    public static final String FORMAT_FITS = "application/fits";
    public static final String FORMAT_HTML = "text/html";
    private static final Logger LOG = LoggerFactory.getLogger(TAPClient.class);
    private final String tapServiceURL;
    private final boolean asyncronous;
    private final HttpClient httpClient;
    private final Executor jaxbExecutor;

    public TAPClient(String tapServiceURL, boolean asyncronous) {
        if (tapServiceURL == null) {
            throw new IllegalArgumentException("TAP service URL not configured");
        }
        if (!((String)tapServiceURL).endsWith("/")) {
            tapServiceURL = (String)tapServiceURL + "/";
        }
        this.tapServiceURL = tapServiceURL;
        this.asyncronous = asyncronous;
        this.jaxbExecutor = JaxbForkJoinWorkerThreadFactory.getJaxbExecutor();
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).executor(this.jaxbExecutor).build();
    }

    public InputStream query(String sqlQuery) {
        return this.query(sqlQuery, null);
    }

    public InputStream query(String sqlQuery, String format) {
        try {
            String bodyParams = "REQUEST=doQuery&LANG=" + this.urlEncode("ADQL-2.0");
            if (format != null) {
                bodyParams = bodyParams + "&FORMAT=" + this.urlEncode(format);
            }
            bodyParams = bodyParams + "&QUERY=" + this.urlEncode(sqlQuery);
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(this.getQueryEndpoint()).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(bodyParams)).build();
            if (this.asyncronous) {
                return (InputStream)((CompletableFuture)((CompletableFuture)this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.discarding()).thenApplyAsync(response -> this.followRedirect((HttpResponse<?>)response), this.jaxbExecutor)).thenApplyAsync(stream -> this.performAsyncQuery((InputStream)stream), this.jaxbExecutor)).join();
            }
            return (InputStream)((CompletableFuture)this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofInputStream()).thenApplyAsync(this.getSuccessInputStreamOrThrowException(), this.jaxbExecutor)).join();
        }
        catch (Throwable t) {
            LOG.error("Exception caught", t);
            throw new TAPServiceException(t);
        }
    }

    private String urlEncode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    private InputStream performAsyncQuery(InputStream response) {
        Job job = this.getJob(response);
        this.checkJobPhase(JobPhase.PENDING, job);
        response = this.startJob(job.getJobId());
        job = this.followAsyncQuery(response);
        String jobResultURL = this.getJobResultURL(job);
        return this.getStream(jobResultURL);
    }

    private String getJobResultURL(Job completedJob) {
        if (completedJob.getResults().isEmpty()) {
            throw new TAPServiceException("Job result missing");
        }
        String jobResultURL = completedJob.getResults().get(0).getHref();
        if (jobResultURL == null || jobResultURL.isEmpty()) {
            throw new TAPServiceException("Job result missing");
        }
        return jobResultURL;
    }

    private void checkJobPhase(JobPhase expectedPhase, Job job) {
        if (!expectedPhase.equals((Object)job.getPhase())) {
            throw new TAPServiceException("Wrong job phase. Expected " + expectedPhase + ", found " + job.getPhase());
        }
    }

    private InputStream startJob(String jobId) {
        String bodyParams = "PHASE=RUN";
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(this.getStartJobEndpoint(jobId)).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(bodyParams)).build();
        return (InputStream)((CompletableFuture)this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.discarding()).thenApplyAsync(response -> this.followRedirect((HttpResponse<?>)response), this.jaxbExecutor)).join();
    }

    private Job followAsyncQuery(InputStream initialResponse) {
        Job job;
        InputStream response = initialResponse;
        do {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            job = this.getJob(response);
            response = this.checkAsyncJobStatus(job);
        } while (JobPhase.EXECUTING.equals((Object)job.getPhase()));
        try {
            response.close();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        if (JobPhase.COMPLETED.equals((Object)job.getPhase())) {
            return job;
        }
        Object msg = job.getErrorSummary() != null && job.getErrorSummary().getMessage() != null ? job.getErrorSummary().getMessage() : "Error while performing async query. Job phase is " + job.getPhase();
        throw new TAPServiceException((String)msg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Job getJob(InputStream stream) {
        try (InputStream inputStream = stream;){
            Job job2 = (Job)JAXB.unmarshal((InputStream)stream, Job.class);
            if (job2 != null) {
                Job job = job2;
                return job;
            }
            LOG.warn("Job unmarshalling returned null");
            throw new TAPServiceException("Unable to parse job info");
        }
        catch (Throwable t) {
            LOG.error("Exception caught", t);
        }
        throw new TAPServiceException("Unable to parse job info");
    }

    private InputStream checkAsyncJobStatus(Job job) {
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(this.getJobStatusEndpoint(job)).GET().build();
        return (InputStream)((CompletableFuture)this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofInputStream()).thenApplyAsync(this.getSuccessInputStreamOrThrowException(), this.jaxbExecutor)).join();
    }

    private InputStream followRedirect(HttpResponse<?> response) {
        if (response.statusCode() == 303) {
            String url = response.headers().firstValue("Location").get();
            return this.getStream(url);
        }
        throw new IllegalStateException("Unexpected status code: " + response.statusCode());
    }

    private InputStream getStream(String url) {
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
        return (InputStream)((CompletableFuture)this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofInputStream()).thenApplyAsync(this.getSuccessInputStreamOrThrowException(), this.jaxbExecutor)).join();
    }

    private Function<HttpResponse<InputStream>, InputStream> getSuccessInputStreamOrThrowException() {
        return response -> {
            if (response.statusCode() == 200) {
                return (InputStream)response.body();
            }
            if (response.statusCode() == 503) {
                try {
                    ((InputStream)response.body()).close();
                }
                catch (IOException ex) {
                    throw new RuntimeException();
                }
                throw new TAPServiceException("TAP service temporarily unavailable");
            }
            throw this.generateExceptionFromErrorResponse((InputStream)response.body(), response.statusCode()).get();
        };
    }

    private URI getQueryEndpoint() {
        return URI.create(this.tapServiceURL + (this.asyncronous ? "async" : "sync"));
    }

    private URI getStartJobEndpoint(String jobId) {
        return URI.create(this.tapServiceURL + "async/" + jobId + "/phase");
    }

    private URI getJobStatusEndpoint(Job job) {
        return URI.create(this.tapServiceURL + "async/" + job.getJobId());
    }

    private Supplier<TAPServiceException> generateExceptionFromErrorResponse(InputStream in, int statusCode) {
        Supplier<TAPServiceException> supplier;
        block9: {
            InputStream inputStream = in;
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                InputSource is = new InputSource(in);
                Document doc = dBuilder.parse(is);
                doc.getDocumentElement().normalize();
                XPathFactory xPathfactory = XPathFactory.newInstance();
                XPath xpath = xPathfactory.newXPath();
                XPathExpression expr = xpath.compile("/VOTABLE/RESOURCE/INFO[@name='QUERY_STATUS']");
                Node node = (Node)expr.evaluate(doc, XPathConstants.NODE);
                String errorMsg = node.getTextContent();
                supplier = () -> new TAPServiceException(errorMsg);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SAXParseException ex) {
                    return () -> new TAPServiceException("TAP service response is not a VOTable. Status code is " + statusCode);
                }
                catch (Throwable t) {
                    LOG.error("Exception caught", t);
                    return () -> new TAPServiceException(t);
                }
            }
            inputStream.close();
        }
        return supplier;
    }

    public TapSchema getTapSchema(String ... columnProperties) {
        return new TapSchemaLoader(this, columnProperties).load();
    }

    public Executor getJaxbExecutor() {
        return this.jaxbExecutor;
    }
}

