/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.tapclient;

import it.inaf.ia2.tapclient.TAPClient;
import it.inaf.ia2.tapclient.TAPServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.json.Json;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryResultsParser {
    private final Logger LOG = LoggerFactory.getLogger(QueryResultsParser.class);
    private final TAPClient client;
    private final String query;
    private JsonParser parser;
    private boolean dataExtracted;

    public QueryResultsParser(TAPClient client, String query) {
        this.client = client;
        this.query = query;
    }

    public abstract void readMetadataItem(Map<String, Object> var1);

    public abstract void readDataRow(List<Object> var1);

    public void parseQuery() throws TAPServiceException {
        try (InputStream in = this.client.query(this.query, "application/json");){
            this.parseQuery(in);
        }
        catch (IOException e) {
            throw new TAPServiceException(e);
        }
    }

    private void parseQuery(InputStream in) throws TAPServiceException {
        this.parser = Json.createParser((InputStream)in);
        try {
            this.checkEvent(JsonParser.Event.START_OBJECT);
            this.checkEvent(JsonParser.Event.KEY_NAME);
            this.extractDataOrMetadata();
            if (!this.dataExtracted) {
                this.checkEvent(JsonParser.Event.KEY_NAME);
                this.extractDataOrMetadata();
            }
            if (!this.dataExtracted) {
                this.throwMalformedJSONException("data key not found");
            }
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            this.parser.close();
        }
    }

    public CompletableFuture<Void> parseQueryRx() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.parseQuery();
            }
            catch (TAPServiceException e) {
                throw new CompletionException(e);
            }
        }, this.client.getJaxbExecutor());
    }

    private void checkHashNext() throws TAPServiceException {
        if (!this.parser.hasNext()) {
            this.throwMalformedJSONException("premature end of stream");
        }
    }

    private JsonParser.Event checkEvent(JsonParser.Event expected) throws TAPServiceException {
        this.checkHashNext();
        JsonParser.Event parsed = this.parser.next();
        if (!expected.equals((Object)parsed)) {
            this.throwMalformedJSONException(String.format("expected %s, found %s", expected, parsed));
        }
        return parsed;
    }

    private void extractDataOrMetadata() throws TAPServiceException {
        String keyName;
        switch (keyName = this.parser.getString().toLowerCase()) {
            case "metadata": {
                this.parseMetadata();
                break;
            }
            case "data": {
                this.parseDataRows();
            }
        }
    }

    private Object parseValue(JsonParser.Event event) throws TAPServiceException {
        switch (event) {
            case VALUE_FALSE: {
                return false;
            }
            case VALUE_TRUE: {
                return true;
            }
            case VALUE_NULL: {
                return null;
            }
            case VALUE_NUMBER: {
                if (this.parser.isIntegralNumber()) {
                    return this.parser.getLong();
                }
                return this.parser.getBigDecimal().doubleValue();
            }
            case VALUE_STRING: {
                return this.parser.getString();
            }
        }
        throw new TAPServiceException("Unexpected JSON event type: " + event.name());
    }

    private Map<String, Object> parseMetadataItem() throws TAPServiceException {
        HashMap<String, Object> item = new HashMap<String, Object>();
        while (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            switch (event) {
                case END_OBJECT: {
                    return item;
                }
                case KEY_NAME: {
                    String key = this.parser.getString();
                    Object value = this.parseValue(this.parser.next());
                    item.put(key, value);
                }
            }
        }
        throw new MalformedJSONException(this.parser, "end of object not found");
    }

    private void parseMetadata() throws TAPServiceException {
        this.checkEvent(JsonParser.Event.START_ARRAY);
        while (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            switch (event) {
                case START_OBJECT: {
                    this.readMetadataItem(this.parseMetadataItem());
                    break;
                }
                case END_ARRAY: {
                    return;
                }
            }
        }
    }

    private List<Object> parseDataRow() throws TAPServiceException {
        ArrayList<Object> row = new ArrayList<Object>();
        while (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            if (event.equals((Object)JsonParser.Event.END_ARRAY)) {
                return row;
            }
            row.add(this.parseValue(event));
        }
        throw new MalformedJSONException(this.parser, "end of array not found");
    }

    private void parseDataRows() throws TAPServiceException {
        this.checkEvent(JsonParser.Event.START_ARRAY);
        while (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            switch (event) {
                case START_ARRAY: {
                    this.readDataRow(this.parseDataRow());
                    break;
                }
                case END_ARRAY: {
                    this.dataExtracted = true;
                    return;
                }
            }
        }
        this.throwMalformedJSONException("end of array not found");
    }

    private void throwMalformedJSONException(String description) throws TAPServiceException {
        throw new MalformedJSONException(this.parser, description);
    }

    private static class MalformedJSONException
    extends TAPServiceException {
        private static final long serialVersionUID = -7417809056811747902L;

        private static String getMessage(JsonParser parser, String description) {
            StringBuilder sb = new StringBuilder("Malformed JSON at ");
            JsonLocation location = parser.getLocation();
            if (location.getLineNumber() == -1L) {
                sb.append("position ").append(location.getStreamOffset());
            } else {
                sb.append("line ").append(location.getLineNumber());
            }
            sb.append(": ").append(description);
            return sb.toString();
        }

        public MalformedJSONException(JsonParser parser, String description) {
            super(MalformedJSONException.getMessage(parser, description));
        }
    }
}

