/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.rap.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.rap.client.RapClient;
import it.inaf.ia2.rap.client.call.TokenExchangeRequest;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenExchangeCall<T>
extends BaseCall<RapClient<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(TokenExchangeCall.class);

    public TokenExchangeCall(RapClient<T> client) {
        super(client);
    }

    public String exchangeToken(TokenExchangeRequest requestData, T context) {
        HttpRequest exchangeRequest;
        Map responseData;
        String newToken;
        String postData = "grant_type=urn:ietf:params:oauth:grant-type:token-exchange&subject_token=" + requestData.getSubjectToken() + "&subject_token_type=Bearer";
        if (requestData.getResource() != null) {
            postData = postData + "&resource=" + requestData.getResource();
        }
        if (requestData.getScopes() != null && !requestData.getScopes().isEmpty()) {
            postData = postData + "&scope=" + this.joinUrlEncoded(requestData.getScopes());
        }
        if (requestData.getAudiences() != null && !requestData.getAudiences().isEmpty()) {
            postData = postData + "&audience=" + this.joinUrlEncoded(requestData.getAudiences());
        }
        if ((newToken = (String)(responseData = ((RapClient)this.client).call(exchangeRequest = ((RapClient)this.client).newClientSecretRequest(((RapClient)this.client).getAccessTokenUri(context)).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(postData)).build(), HttpResponse.BodyHandlers.ofString(), 200, res -> TokenExchangeCall.parseJson(res, Map.class))).get("access_token")) == null) {
            throw new IllegalStateException("Unable to exchange token. New token is null");
        }
        return newToken;
    }

    private String joinUrlEncoded(List<String> values) {
        return values.stream().map(v -> URLEncoder.encode(v, StandardCharsets.UTF_8)).reduce("%20", String::concat);
    }
}

