/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.rap.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.inaf.ia2.client.BaseClient;
import it.inaf.ia2.rap.client.call.CreateUserCall;
import it.inaf.ia2.rap.client.call.GetAccessTokenFromClientCredentialsCall;
import it.inaf.ia2.rap.client.call.GetTokenFromCodeCall;
import it.inaf.ia2.rap.client.call.GetUserCall;
import it.inaf.ia2.rap.client.call.RefreshTokenCall;
import it.inaf.ia2.rap.client.call.TokenResponse;
import it.inaf.ia2.rap.data.AccessTokenResponse;
import it.inaf.ia2.rap.data.Identity;
import it.inaf.ia2.rap.data.RapUser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class RapClient<T>
extends BaseClient {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private String clientId;
    private String clientSecret;
    private String authorizationEndpoint = "/auth/oauth2/authorize";
    private String accessTokenEndpoint = "/auth/oauth2/token";
    private String checkTokenEndpoint = "/auth/oauth2/token";
    private String jwksEndpoint = "/auth/oidc/jwks";
    private String wsUserEndpoint = "/ws/user";

    public RapClient(String rapBaseUrl) {
        super(rapBaseUrl);
    }

    @Override
    protected <T> String getInvalidStatusCodeExceptionMessage(HttpRequest request, HttpResponse<T> response) {
        return response.headers().firstValue("Content-Type").map(contentType -> {
            try {
                if (contentType.startsWith("application/json") || contentType.startsWith("text/json")) {
                    Map errorResponseBody = null;
                    if (response.body() instanceof String) {
                        errorResponseBody = (Map)MAPPER.readValue((String)response.body(), Map.class);
                    } else if (response.body() instanceof InputStream) {
                        errorResponseBody = (Map)MAPPER.readValue((InputStream)response.body(), Map.class);
                    }
                    if (errorResponseBody != null && errorResponseBody.containsKey("error")) {
                        return (String)errorResponseBody.get("error");
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }).orElse(super.getInvalidStatusCodeExceptionMessage(request, response));
    }

    public HttpRequest.Builder newAuthRequest(String endpoint, T context) {
        return this.newAuthRequest(this.newRequest(endpoint, context), context);
    }

    public HttpRequest.Builder newAuthRequest(URI uri, T context) {
        return this.newAuthRequest(this.newRequest(uri, context), context);
    }

    protected HttpRequest.Builder newAuthRequest(HttpRequest.Builder requestBuilder, T context) {
        return this.newBearerRequest(requestBuilder, this.getAccessToken(context));
    }

    protected abstract String getAccessToken(T var1);

    public HttpRequest.Builder newBearerRequest(HttpRequest.Builder requestBuilder, String accessToken) {
        if (accessToken == null) {
            throw new IllegalStateException("Access token is null");
        }
        return requestBuilder.header("Authorization", "Bearer " + accessToken);
    }

    public HttpRequest.Builder newClientSecretRequest(String endpoint) {
        return this.newClientSecretRequest(this.newRequest(endpoint));
    }

    public HttpRequest.Builder newClientSecretRequest(URI uri) {
        return this.newClientSecretRequest(this.newRequest(uri));
    }

    protected HttpRequest.Builder newClientSecretRequest(HttpRequest.Builder requestBuilder) {
        if (this.clientId == null) {
            throw new IllegalStateException("Client id is null");
        }
        if (this.clientSecret == null) {
            throw new IllegalStateException("Client secret is null");
        }
        String basicAuthHeader = this.clientId + ":" + this.clientSecret;
        return requestBuilder.header("Authorization", "Basic " + Base64.getEncoder().encodeToString(basicAuthHeader.getBytes()));
    }

    public HttpRequest.Builder newRequest(String endpoint, T context) {
        return super.newRequest(endpoint);
    }

    public HttpRequest.Builder newRequest(URI uri, T context) {
        return super.newRequest(uri);
    }

    public AccessTokenResponse getAccessTokenFromClientCredentials() {
        return new GetAccessTokenFromClientCredentialsCall(this).getAccessTokenFromClientCredentials();
    }

    public TokenResponse getTokenFromCode(String code, String redirectUri, T context) {
        return new GetTokenFromCodeCall<T>(this).getTokenFromCode(code, redirectUri, context);
    }

    public TokenResponse refreshToken(String refreshToken, String scope, T context) {
        return new RefreshTokenCall<T>(this).refreshToken(refreshToken, scope, context);
    }

    public RapUser getUser(String userId, T context) {
        return new GetUserCall<T>(this).getUser(userId, context);
    }

    public List<RapUser> getUsers(String searchText, T context) {
        return new GetUserCall<T>(this).getUsers(searchText, context);
    }

    public List<RapUser> getUsers(Set<String> identifiers, T context) {
        return new GetUserCall<T>(this).getUsers(identifiers, context);
    }

    public void createUser(Identity identity, T context) {
        new CreateUserCall<T>(this).createUser(identity, context);
    }

    public String getClientId() {
        return this.clientId;
    }

    public RapClient setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public RapClient setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public URI getAuthorizationUri(T context) {
        return this.getUri(this.authorizationEndpoint);
    }

    public RapClient setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
        return this;
    }

    public URI getAccessTokenUri(T context) {
        return this.getUri(this.accessTokenEndpoint);
    }

    public RapClient setAccessTokenEndpoint(String accessTokenEndpoint) {
        this.accessTokenEndpoint = accessTokenEndpoint;
        return this;
    }

    public URI getCheckTokenUri(T context) {
        return this.getUri(this.checkTokenEndpoint);
    }

    public RapClient setCheckTokenEndpoint(String checkTokenEndpoint) {
        this.checkTokenEndpoint = checkTokenEndpoint;
        return this;
    }

    public URI getJwksEndpointUri(T context) {
        return this.getUri(this.jwksEndpoint);
    }

    public RapClient setJwksEndpoint(String jwksEndpoint) {
        this.jwksEndpoint = jwksEndpoint;
        return this;
    }

    public URI getWsUserUri() {
        return this.getUri(this.wsUserEndpoint);
    }

    public void setWsUserEndpoint(String wsUserEndpoint) {
        this.wsUserEndpoint = wsUserEndpoint;
    }
}

