/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.aa.jwt;

import it.inaf.ia2.aa.jwt.Jwk;
import it.inaf.ia2.aa.jwt.Jwks;
import it.inaf.ia2.client.BaseCall;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwksClient {
    private static final Logger LOG = LoggerFactory.getLogger(JwksClient.class);
    private final Set<URI> jwksUris = ConcurrentHashMap.newKeySet();
    private final HttpClient client;

    public JwksClient(URI jwksUri) {
        this.jwksUris.add(jwksUri);
        this.client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
    }

    public List<Jwk> readJwks() {
        return this.jwksUris.stream().map(jwksUri -> this.readJwks((URI)jwksUri)).flatMap(uri -> uri.stream()).collect(Collectors.toList());
    }

    public void addJwksUri(URI jwksUri) {
        this.jwksUris.add(jwksUri);
    }

    public List<Jwk> readJwks(URI jwksUri) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(jwksUri).build();
            List<Jwk> jwks = ((Jwks)((CompletableFuture)((CompletableFuture)this.client.sendAsync(request, HttpResponse.BodyHandlers.ofInputStream()).thenApply(HttpResponse::body)).thenApply(in -> BaseCall.parseJson(in, Jwks.class))).join()).getKeys();
            jwks.remove(null);
            return jwks;
        }
        catch (Throwable t) {
            LOG.error("Error while reading JWKS from " + jwksUri.toString(), t);
            return new ArrayList<Jwk>();
        }
    }
}

