/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.rap.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.client.QueryStringBuilder;
import it.inaf.ia2.rap.client.RapClient;
import it.inaf.ia2.rap.client.call.CodeRequestData;
import it.inaf.ia2.rap.client.call.TokenResponse;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;

public class GetTokenFromCodeCall<T extends CodeRequestData>
extends BaseCall<RapClient> {
    public GetTokenFromCodeCall(RapClient client) {
        super(client);
    }

    public TokenResponse getTokenFromCode(T codeRequest) {
        Map<String, Object> responseMap = this.getTokenFromCodeResponseMap(codeRequest);
        if (!responseMap.containsKey("id_token")) {
            String accessToken = (String)responseMap.get("access_token");
            ((RapClient)this.client).setAccessToken(accessToken);
            Map<String, Object> checkTokenResponseMap = this.getCheckTokenResponseMap(codeRequest);
            for (Map.Entry<String, Object> entry : checkTokenResponseMap.entrySet()) {
                responseMap.put(entry.getKey(), entry.getValue());
            }
        }
        String compositeMap = GetTokenFromCodeCall.toJson(responseMap);
        return GetTokenFromCodeCall.parseJson(compositeMap, TokenResponse.class);
    }

    private Map<String, Object> getTokenFromCodeResponseMap(T codeRequest) {
        String code = ((CodeRequestData)codeRequest).getCode();
        if (code == null) {
            throw new IllegalStateException("Missing code parameter");
        }
        HttpRequest tokenRequest = ((RapClient)this.client).newClientSecretRequest(((RapClient)this.client).getAccessTokenUri(codeRequest)).header("Content-Type", "application/x-www-form-urlencoded").POST(this.getAccessTokenBodyPublisher(codeRequest, code, ((CodeRequestData)codeRequest).getRedirectUri())).build();
        return ((RapClient)this.client).call(tokenRequest, HttpResponse.BodyHandlers.ofString(), 200, res -> GetTokenFromCodeCall.parseJson(res, Map.class));
    }

    private HttpRequest.BodyPublisher getAccessTokenBodyPublisher(T request, String code, String redirectUri) {
        QueryStringBuilder queryStringBuilder = new QueryStringBuilder().param("grant_type", "authorization_code").param("code", code).param("redirect_uri", redirectUri).param("client_id", ((RapClient)this.client).getClientId());
        if (((RapClient)this.client).getAccessTokenUriCustomizer() != null) {
            ((RapClient)this.client).getAccessTokenUriCustomizer().customizeQueryString(request, queryStringBuilder);
        }
        return HttpRequest.BodyPublishers.ofString(queryStringBuilder.getQueryString());
    }

    private Map<String, Object> getCheckTokenResponseMap(T context) {
        HttpRequest tokenRequest = ((RapClient)this.client).newBearerRequest(((RapClient)this.client).getCheckTokenUri(context)).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString("client_id=" + ((RapClient)this.client).getClientId())).build();
        return ((RapClient)this.client).call(tokenRequest, HttpResponse.BodyHandlers.ofString(), 200, res -> GetTokenFromCodeCall.parseJson(res, Map.class));
    }
}

