/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.rap.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.inaf.ia2.aa.jwt.JwksClient;
import it.inaf.ia2.aa.jwt.TokenParser;
import it.inaf.ia2.client.BaseClient;
import it.inaf.ia2.client.UriCustomizer;
import it.inaf.ia2.rap.client.call.CodeRequestData;
import it.inaf.ia2.rap.client.call.CreateUserCall;
import it.inaf.ia2.rap.client.call.GetAccessTokenFromClientCredentialsCall;
import it.inaf.ia2.rap.client.call.GetTokenFromCodeCall;
import it.inaf.ia2.rap.client.call.GetUserCall;
import it.inaf.ia2.rap.client.call.RefreshTokenCall;
import it.inaf.ia2.rap.client.call.TokenResponse;
import it.inaf.ia2.rap.data.AccessTokenResponse;
import it.inaf.ia2.rap.data.Identity;
import it.inaf.ia2.rap.data.RapUser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RapClient
extends BaseClient {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private String clientId;
    private String clientSecret;
    private String accessToken;
    private Long expirationTime;
    private String scope;
    private boolean useClientCredentials;
    private String authorizationEndpoint = "/auth/oauth2/authorize";
    private String accessTokenEndpoint = "/auth/oauth2/token";
    private String checkTokenEndpoint = "/auth/oauth2/token";
    private final String jwksEndpoint = "/auth/oidc/jwks";
    private String wsUserEndpoint = "/ws/user";
    private UriCustomizer authorizationUriCustomizer;
    private UriCustomizer accessTokenUriCustomizer;
    private UriCustomizer checkTokenUriCustomizer;
    private JwksClient jwksClient;
    private TokenParser tokenParser;

    public RapClient(String rapBaseUrl) {
        super(rapBaseUrl);
    }

    public Map<String, Object> parseIdTokenClaims(String idToken) {
        if (this.tokenParser == null) {
            this.setJwksEndpoint("/auth/oidc/jwks");
        }
        return this.tokenParser.getClaims(idToken);
    }

    public RapClient setJwksEndpoint(String jwksEndpoint) {
        this.addJwksUri(this.getUri(jwksEndpoint));
        return this;
    }

    public RapClient addJwksUri(URI jwksUri) {
        if (this.jwksClient == null) {
            this.jwksClient = new JwksClient(jwksUri);
            this.tokenParser = new TokenParser(this.jwksClient);
        } else {
            this.jwksClient.addJwksUri(jwksUri);
        }
        return this;
    }

    @Override
    protected <T> String getInvalidStatusCodeExceptionMessage(HttpRequest request, HttpResponse<T> response) {
        return response.headers().firstValue("Content-Type").map(contentType -> {
            try {
                if (contentType.startsWith("application/json") || contentType.startsWith("text/json")) {
                    Map errorResponseBody = null;
                    if (response.body() instanceof String) {
                        errorResponseBody = (Map)MAPPER.readValue((String)response.body(), Map.class);
                    } else if (response.body() instanceof InputStream) {
                        errorResponseBody = (Map)MAPPER.readValue((InputStream)response.body(), Map.class);
                    }
                    if (errorResponseBody != null && errorResponseBody.containsKey("error")) {
                        return (String)errorResponseBody.get("error");
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }).orElse(super.getInvalidStatusCodeExceptionMessage(request, response));
    }

    public HttpRequest.Builder newBearerRequest(String endpoint) {
        return this.newBearerRequest(this.newRequest(endpoint));
    }

    public HttpRequest.Builder newBearerRequest(URI uri) {
        return this.newBearerRequest(this.newRequest(uri));
    }

    public HttpRequest.Builder newBearerRequest(HttpRequest.Builder requestBuilder) {
        boolean clientCredentials = this.hasClientCredentials();
        if (clientCredentials && this.accessTokenExpired()) {
            this.accessToken = null;
        }
        if (this.accessToken == null) {
            if (clientCredentials) {
                AccessTokenResponse response = this.getAccessTokenFromClientCredentials();
                this.accessToken = response.getAccessToken();
                this.expirationTime = System.currentTimeMillis() / 1000L + (long)response.getExpiresIn();
            } else {
                throw new IllegalStateException("Access token is null");
            }
        }
        return requestBuilder.header("Authorization", "Bearer " + this.accessToken);
    }

    private boolean accessTokenExpired() {
        return this.expirationTime != null && this.expirationTime < System.currentTimeMillis() / 1000L;
    }

    public HttpRequest.Builder newClientSecretRequest(String endpoint) {
        return this.newClientSecretRequest(this.newRequest(endpoint));
    }

    public HttpRequest.Builder newClientSecretRequest(URI uri) {
        return this.newClientSecretRequest(this.newRequest(uri));
    }

    private HttpRequest.Builder newClientSecretRequest(HttpRequest.Builder requestBuilder) {
        if (this.clientId == null) {
            throw new IllegalStateException("Client id is null");
        }
        if (this.clientSecret == null) {
            throw new IllegalStateException("Client secret is null");
        }
        String basicAuthHeader = this.clientId + ":" + this.clientSecret;
        return requestBuilder.header("Authorization", "Basic " + Base64.getEncoder().encodeToString(basicAuthHeader.getBytes()));
    }

    public AccessTokenResponse getAccessTokenFromClientCredentials() {
        return new GetAccessTokenFromClientCredentialsCall(this).getAccessTokenFromClientCredentials();
    }

    public <T extends CodeRequestData> TokenResponse getTokenFromCode(T codeRequest) {
        return new GetTokenFromCodeCall<T>(this).getTokenFromCode(codeRequest);
    }

    public TokenResponse refreshToken(String refreshToken, Object context) {
        return new RefreshTokenCall(this).refreshToken(refreshToken, context);
    }

    public RapUser getUser(String userId) {
        return new GetUserCall(this).getUser(userId);
    }

    public List<RapUser> getUsers(String searchText) {
        return new GetUserCall(this).getUsers(searchText);
    }

    public List<RapUser> getUsers(Set<String> identifiers) {
        return new GetUserCall(this).getUsers(identifiers);
    }

    public void createUser(Identity identity) {
        new CreateUserCall(this).createUser(identity);
    }

    public String getClientId() {
        return this.clientId;
    }

    public RapClient setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public RapClient setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public RapClient setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public UriCustomizer getAuthorizationUriCustomizer() {
        return this.authorizationUriCustomizer;
    }

    public RapClient setAuthorizationUriCustomizer(UriCustomizer authorizationUriCustomizer) {
        this.authorizationUriCustomizer = authorizationUriCustomizer;
        return this;
    }

    public UriCustomizer getAccessTokenUriCustomizer() {
        return this.accessTokenUriCustomizer;
    }

    public RapClient setAccessTokenUriCustomizer(UriCustomizer accessTokenUriCustomizer) {
        this.accessTokenUriCustomizer = accessTokenUriCustomizer;
        return this;
    }

    public UriCustomizer getCheckTokenUriCustomizer() {
        return this.checkTokenUriCustomizer;
    }

    public RapClient setCheckTokenUriCustomizer(UriCustomizer checkTokenUriCustomizer) {
        this.checkTokenUriCustomizer = checkTokenUriCustomizer;
        return this;
    }

    public URI getAuthorizationUri(Object context) {
        if (this.authorizationUriCustomizer != null) {
            return this.authorizationUriCustomizer.getBaseUri(context);
        }
        return this.getUri(this.authorizationEndpoint);
    }

    public RapClient setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
        return this;
    }

    public URI getAccessTokenUri(Object context) {
        if (this.accessTokenUriCustomizer != null) {
            return this.accessTokenUriCustomizer.getBaseUri(context);
        }
        return this.getUri(this.accessTokenEndpoint);
    }

    public RapClient setAccessTokenEndpoint(String accessTokenEndpoint) {
        this.accessTokenEndpoint = accessTokenEndpoint;
        return this;
    }

    public URI getCheckTokenUri(Object context) {
        if (this.checkTokenUriCustomizer != null) {
            return this.checkTokenUriCustomizer.getBaseUri(context);
        }
        return this.getUri(this.checkTokenEndpoint);
    }

    public RapClient setCheckTokenEndpoint(String checkTokenEndpoint) {
        this.checkTokenEndpoint = checkTokenEndpoint;
        return this;
    }

    public URI getWsUserUri() {
        return this.getUri(this.wsUserEndpoint);
    }

    public void setWsUserEndpoint(String wsUserEndpoint) {
        this.wsUserEndpoint = wsUserEndpoint;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    private boolean hasClientCredentials() {
        return this.useClientCredentials && this.clientId != null && !this.clientId.isBlank() && this.clientSecret != null && !this.clientSecret.isBlank();
    }

    public RapClient setUseClientCredentials(boolean useClientCredentials) {
        this.useClientCredentials = useClientCredentials;
        return this;
    }
}

