/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.aa.jwt;

import it.inaf.ia2.aa.jwt.Jwk;
import it.inaf.ia2.aa.jwt.Jwks;
import it.inaf.ia2.client.BaseCall;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class JwksClient {
    private final Set<URI> jwksUris = ConcurrentHashMap.newKeySet();
    private final HttpClient client;

    public JwksClient(URI jwksUri) {
        this.jwksUris.add(jwksUri);
        this.client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
    }

    public List<Jwk> readJwks() {
        return this.jwksUris.stream().map(jwksUri -> this.readJwks((URI)jwksUri)).flatMap(uri -> uri.stream()).collect(Collectors.toList());
    }

    public void addJwksUri(URI jwksUri) {
        this.jwksUris.add(jwksUri);
    }

    public List<Jwk> readJwks(URI jwksUri) {
        HttpRequest request = HttpRequest.newBuilder().uri(jwksUri).build();
        return ((Jwks)((CompletableFuture)((CompletableFuture)this.client.sendAsync(request, HttpResponse.BodyHandlers.ofInputStream()).thenApply(HttpResponse::body)).thenApply(in -> BaseCall.parseJson(in, Jwks.class))).join()).getKeys();
    }
}

