/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.rap.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.rap.client.RapClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GetAccessTokenFromClientCredentialsCall
extends BaseCall<RapClient> {
    public GetAccessTokenFromClientCredentialsCall(RapClient client) {
        super(client);
    }

    public String getAccessTokenFromClientCredentials() {
        HttpRequest tokenRequest = ((RapClient)this.client).newClientSecretRequest(((RapClient)this.client).getAccessTokenUri(null)).header("Accept", "application/json").header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString("grant_type=client_credentials")).build();
        return ((RapClient)this.client).call(tokenRequest, HttpResponse.BodyHandlers.ofString(), 200, res -> this.getAccessTokenFromResponse((String)res));
    }

    protected String getAccessTokenFromResponse(String body) {
        Pattern codePattern = Pattern.compile(".*\"access_token\":\\s*\"([^\"]+).*");
        Matcher matcher = codePattern.matcher(body);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalStateException("Unable to extract access token from body");
    }
}

