/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.exception.BadRequestException;
import it.inaf.ia2.gms.persistence.GroupsDAO;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupNameService {
    private final GroupsDAO groupsDAO;

    @Autowired
    public GroupNameService(GroupsDAO groupsDAO) {
        this.groupsDAO = groupsDAO;
    }

    public List<String> getGroupsNamesFromIdentifiers(Set<String> groupIdentifiers) {
        return this.getGroupsNames(this.groupsDAO.findGroupsByIds(groupIdentifiers));
    }

    public String getGroupCompleteName(GroupEntity group) {
        return this.getGroupsNames(Collections.singletonList(group)).get(0);
    }

    public List<String> getGroupsNames(List<GroupEntity> groups) {
        Set<String> groupIds = groups.stream().map(g -> g.getId()).collect(Collectors.toSet());
        ArrayList<String> names = new ArrayList<String>(this.groupsDAO.getGroupCompleteNamesFromId(groupIds).values());
        Collections.sort(names);
        return names;
    }

    public Map<String, List<String>> getNames(Set<GroupEntity> groups) {
        Set<String> groupIds = groups.stream().map(g -> g.getId()).collect(Collectors.toSet());
        return this.getNamesFromIds(groupIds);
    }

    public Map<String, List<String>> getNamesFromIds(Set<String> groupIds) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (groupIds.contains("ROOT")) {
            result.put("ROOT", Collections.singletonList(this.getRoot().getName()));
        }
        for (Map.Entry<String, String> entry : this.groupsDAO.getGroupCompleteNamesFromId(groupIds).entrySet()) {
            List<String> names = this.splitNames(entry.getValue());
            result.put(entry.getKey(), names);
        }
        return result;
    }

    private List<String> splitNames(String completeGroupName) {
        return Arrays.stream(completeGroupName.split("(?<!\\\\)\\.")).map(name -> name.replace("\\.", ".")).collect(Collectors.toList());
    }

    public String getShortGroupName(String completeGroupName, Optional<String> groupPrefix) {
        if (groupPrefix.isPresent() && !groupPrefix.get().isBlank()) {
            if (groupPrefix.get().endsWith(".")) {
                return completeGroupName.substring(groupPrefix.get().length());
            }
            return completeGroupName.substring(groupPrefix.get().length() + 1);
        }
        return completeGroupName;
    }

    public GroupEntity getGroupFromNames(Optional<String> group) {
        List<String> groupNames = this.extractGroupNames(group);
        if (groupNames.isEmpty()) {
            return this.getRoot();
        }
        return this.getGroupFromNamesAndIndex(groupNames, groupNames.size() - 1);
    }

    public GroupEntity getGroupFromNamesAndIndex(Optional<String> group, int index) {
        List<String> groupNames = this.extractGroupNames(group);
        return this.getGroupFromNamesAndIndex(groupNames, index);
    }

    private GroupEntity getGroupFromNamesAndIndex(List<String> groupNames, int index) {
        String parentPath = "";
        GroupEntity group = null;
        for (int i = 0; i < index + 1; ++i) {
            String groupName = groupNames.get(i);
            group = this.groupsDAO.findGroupByParentAndName(parentPath, groupName).orElseThrow(() -> new BadRequestException("Unable to find group " + groupName));
            parentPath = group.getPath();
        }
        if (group == null) {
            throw new IllegalStateException();
        }
        return group;
    }

    private List<String> extractGroupNames(Optional<String> group) {
        return this.extractGroupNames((String)group.orElse(null));
    }

    public List<String> extractGroupNames(String groupStr) {
        if (groupStr == null || groupStr.isEmpty()) {
            return new ArrayList<String>();
        }
        groupStr = URLDecoder.decode(groupStr, StandardCharsets.UTF_8);
        ArrayList<String> names = new ArrayList<String>();
        String currentName = "";
        for (int i = 0; i < groupStr.length(); ++i) {
            char c = groupStr.charAt(i);
            if (c == '.' && groupStr.charAt(i - 1) != '\\') {
                names.add(currentName.replace("\\.", "."));
                currentName = "";
                continue;
            }
            currentName = currentName + c;
        }
        names.add(currentName.replace("\\.", "."));
        return names;
    }

    public String getCompleteName(List<String> names) {
        return String.join((CharSequence)".", names.stream().map(n -> n.replace(".", "\\.")).collect(Collectors.toList()));
    }

    private GroupEntity getRoot() {
        return this.groupsDAO.findGroupById("ROOT").orElseThrow(() -> new IllegalStateException("Missing root group"));
    }
}

