/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.model.response;

import java.util.ArrayList;
import java.util.List;

public class PaginatedData<T> {
    private static final int LINKS_SIZE = 5;
    private final List<T> items;
    private final int currentPage;
    private final List<Integer> links;
    private final int totalItems;
    private final int pageSize;
    private final int totalPages;
    private final boolean hasPreviousPages;
    private final boolean hasFollowingPages;

    public PaginatedData(List<T> allItems, int page, int pageSize) {
        if (page < 1) {
            throw new IllegalArgumentException("Page numbers start from 1");
        }
        this.totalItems = allItems.size();
        this.pageSize = pageSize;
        this.totalPages = this.totalItems == 0 ? 1 : (int)Math.ceil((double)this.totalItems / (double)pageSize);
        this.currentPage = page <= this.totalPages ? page : this.totalPages;
        if (allItems.isEmpty()) {
            this.items = allItems;
        } else {
            int firstElementIndex = (this.currentPage - 1) * pageSize;
            int lastElementIndex = Math.min(this.currentPage * pageSize - 1, this.totalItems - 1);
            this.items = new ArrayList<T>(allItems.subList(firstElementIndex, lastElementIndex + 1));
        }
        this.links = new ArrayList<Integer>();
        int start = this.currentPage - 2;
        if (start > 1 && start + 5 > this.totalPages) {
            start = this.totalPages - 5 + 1;
        }
        if (start < 1) {
            start = 1;
        }
        int i = start;
        boolean bl = this.hasPreviousPages = start > 1;
        while (i < start + 5 && i <= this.totalPages) {
            this.links.add(i++);
        }
        this.hasFollowingPages = this.totalPages > i;
    }

    public List<T> getItems() {
        return this.items;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public List<Integer> getLinks() {
        return this.links;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public boolean isHasPreviousPages() {
        return this.hasPreviousPages;
    }

    public boolean isHasFollowingPages() {
        return this.hasFollowingPages;
    }
}

