/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.manager.MembershipManager;
import it.inaf.ia2.gms.manager.PermissionsManager;
import it.inaf.ia2.gms.model.request.AddMemberRequest;
import it.inaf.ia2.gms.model.request.PaginatedModelRequest;
import it.inaf.ia2.gms.model.request.RemoveMemberRequest;
import it.inaf.ia2.gms.model.request.TabRequest;
import it.inaf.ia2.gms.model.response.PaginatedData;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.service.GroupNameService;
import it.inaf.ia2.gms.service.GroupsService;
import it.inaf.ia2.rap.data.RapUser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MembersController {
    @Autowired
    private GroupsService groupsService;
    @Autowired
    private MembershipManager membershipManager;
    @Autowired
    private PermissionsManager permissionsManager;
    @Autowired
    protected GroupNameService groupNameService;

    @GetMapping(value={"/ui/members"}, produces={"application/json"})
    public ResponseEntity<PaginatedData<RapUser>> getMembersTab(TabRequest request) {
        GroupEntity group = this.groupsService.getGroupById(request.getGroupId());
        PaginatedData<RapUser> membersPanel = this.getMembersPanel(group, request);
        return ResponseEntity.ok(membersPanel);
    }

    @PostMapping(value={"/ui/member"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<PaginatedData<RapUser>> addMember(@Valid @RequestBody AddMemberRequest request) {
        GroupEntity group = this.groupsService.getGroupById(request.getGroupId());
        this.membershipManager.addMember(group, request.getUserId());
        this.permissionsManager.addPermission(group, request.getUserId(), request.getPermission());
        return new ResponseEntity(this.getMembersPanel(group, request), HttpStatus.CREATED);
    }

    @DeleteMapping(value={"/ui/member"}, produces={"application/json"})
    public ResponseEntity<PaginatedData<RapUser>> removeMember(@Valid RemoveMemberRequest request) {
        GroupEntity group = this.groupsService.getGroupById(request.getGroupId());
        this.membershipManager.removeMember(group, request.getUserId());
        if (request.isRemoveAlsoPermission()) {
            this.permissionsManager.removePermission(group, request.getUserId());
        }
        return ResponseEntity.ok(this.getMembersPanel(group, request));
    }

    private PaginatedData<RapUser> getMembersPanel(GroupEntity group, PaginatedModelRequest request) {
        List<RapUser> members = this.membershipManager.getMembers(group);
        Collections.sort(members, (m1, m2) -> m1.getDisplayName().compareTo(m2.getDisplayName()));
        return new PaginatedData<RapUser>(members, request.getPaginatorPage(), request.getPaginatorPageSize());
    }

    @GetMapping(value={"/membership"}, produces={"text/plain"})
    public void getMembership(@RequestParam(value="group") Optional<String> groupNames, @RequestParam(value="user_id") String userId, HttpServletResponse response) throws IOException {
        GroupEntity parent = this.groupNameService.getGroupFromNames(groupNames);
        List<GroupEntity> groups = this.membershipManager.getUserGroups(parent, userId);
        try (PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());){
            for (String groupName : this.groupNameService.getGroupsNames(groups)) {
                pw.println(this.groupNameService.getShortGroupName(groupName, groupNames));
            }
        }
    }

    @PostMapping(value={"/membership"}, produces={"text/plain"}, consumes={"application/x-www-form-urlencoded"})
    public void addMember(@RequestParam(value="group") Optional<String> groupNames, @RequestParam(value="user_id") String targetUserId) {
        GroupEntity groupEntity = this.groupNameService.getGroupFromNames(groupNames);
        this.membershipManager.addMember(groupEntity, targetUserId);
    }

    @DeleteMapping(value={"/membership"}, produces={"text/plain"})
    public ResponseEntity<?> removeMember(@RequestParam(value="group") Optional<String> groupNames, @RequestParam(value="user_id") String userId) {
        GroupEntity groupEntity = this.groupNameService.getGroupFromNames(groupNames);
        this.membershipManager.removeMember(groupEntity, userId);
        return ResponseEntity.noContent().build();
    }
}

