/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.controller;

import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
public class DALIController {
    @Autowired
    private HttpServletRequest request;

    @GetMapping(value={"/vo/capabilities"}, produces={"application/xml", "text/xml"})
    public String getCapabilities() throws IOException {
        String xml = this.loadXmlFile("capabilities.xml");
        return xml.replace("{{ base_url }}", this.getBaseUrl());
    }

    @GetMapping(value={"/vo/availability"}, produces={"application/xml", "text/xml"})
    public String getAvailability() throws IOException {
        String xml = this.loadXmlFile("availability.xml");
        return xml.replace("{{ base_url }}", this.getBaseUrl());
    }

    private String loadXmlFile(String fileName) throws IOException {
        try (InputStream in = DALIController.class.getClassLoader().getResourceAsStream(fileName);){
            Scanner s = new Scanner(in).useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }

    private String getBaseUrl() {
        String forwaredProtocol = this.request.getHeader("X-Forwarded-Proto");
        String scheme = forwaredProtocol != null ? forwaredProtocol : this.request.getScheme();
        String forwardedHost = this.request.getHeader("X-Forwarded-Host");
        if (forwardedHost != null && forwardedHost.contains(",")) {
            forwardedHost = forwardedHost.split(",")[0];
        }
        String host = forwardedHost != null ? forwardedHost : this.request.getServerName();
        UriComponentsBuilder builder = UriComponentsBuilder.newInstance().scheme(scheme).host(host).path(this.request.getContextPath());
        if (forwardedHost == null) {
            builder.port(this.request.getServerPort());
        }
        return builder.toUriString();
    }
}

