/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.authn;

import it.inaf.ia2.aa.LoginFilter;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.AntPathMatcher;

public class GmsLoginFilter
extends LoginFilter {
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        if (this.shouldNotFilter(request)) {
            fc.doFilter(req, res);
        } else {
            super.doFilter(req, res, fc);
        }
    }

    private boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        if (request.getUserPrincipal() != null) {
            return true;
        }
        if ("OPTIONS".equals(request.getMethod())) {
            return true;
        }
        AntPathMatcher pathMatcher = new AntPathMatcher();
        return Arrays.asList("/ws/jwt/**", "/error", "/logout", "/invited-registration", "/help/**", "/vo/capabilities", "/vo/availability").stream().anyMatch(p -> pathMatcher.match(p, request.getServletPath()));
    }
}

