/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.authn.RapClient;
import it.inaf.ia2.gms.manager.GroupsManager;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.request.GenericSearchRequest;
import it.inaf.ia2.gms.model.response.PaginatedData;
import it.inaf.ia2.gms.model.response.SearchResponseItem;
import it.inaf.ia2.gms.model.response.SearchResponseType;
import it.inaf.ia2.gms.model.response.UserGroup;
import it.inaf.ia2.gms.model.response.UserPermission;
import it.inaf.ia2.gms.model.response.UserSearchResponse;
import it.inaf.ia2.gms.persistence.GroupsDAO;
import it.inaf.ia2.gms.persistence.MembershipsDAO;
import it.inaf.ia2.gms.persistence.PermissionsDAO;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import it.inaf.ia2.gms.service.GroupNameService;
import it.inaf.ia2.gms.service.PermissionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchService {
    @Autowired
    private RapClient rapClient;
    @Autowired
    private GroupsManager groupsManager;
    @Autowired
    private GroupsDAO groupsDAO;
    @Autowired
    private PermissionsDAO permissionsDAO;
    @Autowired
    private MembershipsDAO membershipsDAO;
    @Autowired
    private GroupNameService groupNameService;

    public PaginatedData<SearchResponseItem> search(GenericSearchRequest searchRequest, String userId) {
        ArrayList<SearchResponseItem> items = new ArrayList<SearchResponseItem>();
        if (searchRequest.isUsers()) {
            items.addAll(this.searchUsers(searchRequest.getQuery()));
        }
        if (searchRequest.isGroups()) {
            items.addAll(this.searchGroups(searchRequest.getQuery(), userId));
        }
        items.sort((i1, i2) -> i1.getLabel().compareTo(i2.getLabel()));
        return new PaginatedData<SearchResponseItem>(items, searchRequest.getPaginatorPage(), searchRequest.getPaginatorPageSize());
    }

    private List<SearchResponseItem> searchUsers(String query) {
        return this.rapClient.getUsers(query).stream().map(u -> {
            SearchResponseItem item = new SearchResponseItem();
            item.setType(SearchResponseType.USER);
            item.setId(u.getId());
            item.setLabel(u.getDisplayName());
            return item;
        }).collect(Collectors.toList());
    }

    private List<SearchResponseItem> searchGroups(String query, String userId) {
        List<GroupEntity> allGroups = this.groupsDAO.searchGroups(query);
        List<PermissionEntity> permissions = this.permissionsDAO.findUserPermissions(userId);
        Set<GroupEntity> visibleGroups = this.getVisibleGroups(allGroups, permissions);
        ArrayList<SearchResponseItem> items = new ArrayList<SearchResponseItem>();
        Map<String, List<String>> groupNames = this.groupNameService.getNames(visibleGroups);
        for (GroupEntity group : visibleGroups) {
            SearchResponseItem item = new SearchResponseItem();
            item.setType(SearchResponseType.GROUP);
            item.setId(group.getId());
            List<String> names = groupNames.get(group.getId());
            item.setLabel(String.join((CharSequence)" / ", names));
            items.add(item);
        }
        return items;
    }

    public UserSearchResponse getUserSearchResult(String actorUserId, String targetUserId) {
        List<PermissionEntity> actorPermissions = this.permissionsDAO.findUserPermissions(actorUserId);
        UserSearchResponse response = new UserSearchResponse();
        List<UserGroup> groups = this.getUserGroups(targetUserId, actorPermissions);
        this.sortByGroupCompleteName(groups);
        response.setGroups(groups);
        List<UserPermission> permissions = this.getUserPermission(this.groupsManager.getRoot(), targetUserId, actorPermissions);
        this.sortByGroupCompleteName(permissions);
        response.setPermissions(permissions);
        response.setUser(this.rapClient.getUser(targetUserId));
        return response;
    }

    private List<UserGroup> getUserGroups(String targetUserId, List<PermissionEntity> actorPermissions) {
        List<GroupEntity> allGroups = this.membershipsDAO.getUserMemberships(targetUserId);
        Set<GroupEntity> visibleGroups = this.getVisibleGroups(allGroups, actorPermissions);
        return this.groupNameService.getNames(visibleGroups).entrySet().stream().map(entry -> {
            UserGroup ug = new UserGroup();
            ug.setGroupId((String)entry.getKey());
            ug.setGroupCompleteName((List)entry.getValue());
            return ug;
        }).collect(Collectors.toList());
    }

    private Set<GroupEntity> getVisibleGroups(List<GroupEntity> allGroups, List<PermissionEntity> permissions) {
        return allGroups.stream().filter(g -> PermissionUtils.getGroupPermission(g, permissions).isPresent()).collect(Collectors.toSet());
    }

    public List<UserPermission> getUserPermission(GroupEntity group, String targetUserId, List<PermissionEntity> actorPermissions) {
        ArrayList<UserPermission> permissions = new ArrayList<UserPermission>();
        PermissionUtils.getGroupPermission(group, actorPermissions).ifPresent(permission -> {
            if (permission.equals((Object)Permission.ADMIN)) {
                Map<String, PermissionEntity> targetUserPermissions = this.permissionsDAO.findUserPermissions(targetUserId).stream().collect(Collectors.toMap(PermissionEntity::getGroupId, p -> p));
                Set<String> groupIds = targetUserPermissions.values().stream().map(p -> p.getGroupId()).collect(Collectors.toSet());
                for (Map.Entry<String, List<String>> entry : this.groupNameService.getNamesFromIds(groupIds).entrySet()) {
                    UserPermission up = new UserPermission();
                    up.setGroupId(entry.getKey());
                    up.setGroupCompleteName(entry.getValue());
                    up.setPermission(targetUserPermissions.get(entry.getKey()).getPermission());
                    permissions.add(up);
                }
            }
        });
        return permissions;
    }

    private void sortByGroupCompleteName(List<? extends UserGroup> items) {
        items.sort((i1, i2) -> {
            String completeName1 = String.join((CharSequence)" / ", i1.getGroupCompleteName());
            String completeName2 = String.join((CharSequence)" / ", i2.getGroupCompleteName());
            return completeName1.compareTo(completeName2);
        });
    }
}

