/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.model.GroupNode;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.request.PaginatedModelRequest;
import it.inaf.ia2.gms.model.request.SearchFilterRequest;
import it.inaf.ia2.gms.model.response.PaginatedData;
import it.inaf.ia2.gms.persistence.GroupsDAO;
import it.inaf.ia2.gms.persistence.PermissionsDAO;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import it.inaf.ia2.gms.service.PermissionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupsTreeBuilder {
    private final GroupsDAO groupsDAO;
    private final PermissionsDAO permissionsDAO;

    @Autowired
    public GroupsTreeBuilder(GroupsDAO groupsDAO, PermissionsDAO permissionsDAO) {
        this.groupsDAO = groupsDAO;
        this.permissionsDAO = permissionsDAO;
    }

    public <T extends PaginatedModelRequest> PaginatedData<GroupNode> listSubGroups(GroupEntity parentGroup, T request, String userId) {
        List<GroupEntity> allGroups = this.groupsDAO.getDirectSubGroups(parentGroup.getPath(), ((SearchFilterRequest)((Object)request)).getSearchFilter());
        List<PermissionEntity> permissions = this.permissionsDAO.findUserPermissions(userId);
        List<GroupNode> userGroups = this.filterOnPermissions(allGroups, permissions);
        PaginatedData<GroupNode> paginatedGroups = new PaginatedData<GroupNode>(userGroups, request.getPaginatorPage(), request.getPaginatorPageSize());
        this.fillHasChildrenFlags(paginatedGroups.getItems());
        return paginatedGroups;
    }

    private List<GroupNode> filterOnPermissions(List<GroupEntity> allGroups, List<PermissionEntity> permissions) {
        ArrayList<GroupNode> nodes = new ArrayList<GroupNode>();
        for (GroupEntity group : allGroups) {
            PermissionUtils.getGroupPermission(group, permissions).ifPresent(permission -> {
                GroupNode node = new GroupNode();
                node.setGroupId(group.getId());
                node.setGroupName(group.getName());
                node.setLeaf(group.isLeaf());
                node.setLocked(group.isLocked());
                node.setPermission((Permission)((Object)permission));
                node.setCreatedBy(group.getCreatedBy());
                node.setCreationTime(group.getCreationTime());
                nodes.add(node);
            });
        }
        nodes.sort((n1, n2) -> n1.getGroupName().compareTo(n2.getGroupName()));
        return nodes;
    }

    private void fillHasChildrenFlags(List<GroupNode> groups) {
        Set<String> groupIds = groups.stream().map(g -> g.getGroupId()).collect(Collectors.toSet());
        Map<String, Boolean> hasChildrenMap = this.groupsDAO.getHasChildrenMap(groupIds);
        for (GroupNode group : groups) {
            group.setHasChildren(hasChildrenMap.get(group.getGroupId()));
        }
    }
}

