/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.persistence;

import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class PermissionsDAO {
    private static final String PERMISSION_COLUMNS = "group_id, user_id, permission, group_path, update_time, set_by";
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public PermissionsDAO(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public PermissionEntity createOrUpdatePermission(PermissionEntity userPermission) {
        String sql = "INSERT INTO gms_permission(group_id, user_id, permission, group_path, set_by) VALUES(?, ?, ?, ?, ?)\nON CONFLICT (group_id, user_id) DO UPDATE\nSET permission = EXCLUDED.permission, set_by = EXCLUDED.set_by, update_time = NOW()";
        this.jdbcTemplate.update(conn -> {
            int i = 0;
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(++i, userPermission.getGroupId());
            ps.setString(++i, userPermission.getUserId());
            ps.setObject(++i, (Object)userPermission.getPermission().toString(), 1111);
            ps.setObject(++i, (Object)userPermission.getGroupPath(), 1111);
            ps.setString(++i, userPermission.getSetBy());
            return ps;
        });
        return userPermission;
    }

    public PermissionEntity updatePermission(PermissionEntity userPermission) {
        String sql = "UPDATE gms_permission SET permission = ?, set_by = ?, update_time = NOW()  WHERE group_id = ? AND user_id = ? AND group_path = ?";
        this.jdbcTemplate.update(conn -> {
            int i = 0;
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setObject(++i, (Object)userPermission.getPermission().toString(), 1111);
            ps.setString(++i, userPermission.getSetBy());
            ps.setString(++i, userPermission.getGroupId());
            ps.setString(++i, userPermission.getUserId());
            ps.setObject(++i, (Object)userPermission.getGroupPath(), 1111);
            return ps;
        });
        return userPermission;
    }

    public List<PermissionEntity> findUserPermissions(String userId) {
        String sql = "SELECT group_id, user_id, permission, group_path, update_time, set_by FROM gms_permission WHERE user_id = ?";
        return (List)this.jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, userId);
            return ps;
        }, resultSet -> this.getPermissionsFromResultSet(resultSet));
    }

    public List<PermissionEntity> findUserPermissions(String userId, String path) {
        String sql = "SELECT group_id, user_id, permission, group_path, update_time, set_by FROM gms_permission WHERE user_id = ?\nAND (group_path <@ ? OR group_path @> ?)";
        return (List)this.jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, userId);
            ps.setObject(2, (Object)path, 1111);
            ps.setObject(3, (Object)path, 1111);
            return ps;
        }, resultSet -> this.getPermissionsFromResultSet(resultSet));
    }

    public Optional<PermissionEntity> findPermissionEntity(String groupId, String userId) {
        String sql = "SELECT group_id, user_id, permission, group_path, update_time, set_by FROM gms_permission WHERE group_id = ? AND user_id = ?";
        return (Optional)this.jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, groupId);
            ps.setString(2, userId);
            return ps;
        }, resultSet -> {
            if (resultSet.next()) {
                return Optional.of(this.getPermissionEntityFromResultSet(resultSet));
            }
            return Optional.empty();
        });
    }

    public List<PermissionEntity> getGroupsPermissions(String groupId) {
        String sql = "SELECT group_id, user_id, permission, group_path, update_time, set_by FROM gms_permission WHERE group_id = ?";
        return (List)this.jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, groupId);
            return ps;
        }, resultSet -> this.getPermissionsFromResultSet(resultSet));
    }

    private List<PermissionEntity> getPermissionsFromResultSet(ResultSet resultSet) throws SQLException {
        ArrayList<PermissionEntity> permissions = new ArrayList<PermissionEntity>();
        while (resultSet.next()) {
            permissions.add(this.getPermissionEntityFromResultSet(resultSet));
        }
        return permissions;
    }

    private PermissionEntity getPermissionEntityFromResultSet(ResultSet resultSet) throws SQLException {
        PermissionEntity permission = new PermissionEntity();
        permission.setGroupId(resultSet.getString("group_id"));
        permission.setUserId(resultSet.getString("user_id"));
        permission.setPermission(Permission.valueOf(resultSet.getString("permission")));
        permission.setGroupPath(resultSet.getString("group_path"));
        permission.setSetBy(resultSet.getString("set_by"));
        permission.setUpdateTime(new Date(resultSet.getDate("update_time").getTime()));
        return permission;
    }

    public void deletePermission(String groupId, String userId) {
        String sql = "DELETE FROM gms_permission WHERE group_id = ? AND user_id = ?";
        this.jdbcTemplate.update(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, groupId);
            ps.setString(2, userId);
            return ps;
        });
    }

    public void deleteAllGroupsPermissions(List<String> groupIds) {
        if (groupIds.isEmpty()) {
            return;
        }
        String sql = "DELETE FROM gms_permission WHERE group_id IN (" + String.join((CharSequence)",", groupIds.stream().map(g -> "?").collect(Collectors.toList())) + ")";
        this.jdbcTemplate.update(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            int i = 0;
            for (String groupId : groupIds) {
                ps.setString(++i, groupId);
            }
            return ps;
        });
    }
}

