/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.manager;

import it.inaf.ia2.gms.authn.RapClient;
import it.inaf.ia2.gms.exception.UnauthorizedException;
import it.inaf.ia2.gms.manager.UserAwareComponent;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.RapUserPermission;
import it.inaf.ia2.gms.persistence.LoggingDAO;
import it.inaf.ia2.gms.persistence.model.ActionType;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import it.inaf.ia2.gms.service.PermissionUtils;
import it.inaf.ia2.gms.service.PermissionsService;
import it.inaf.ia2.rap.data.RapUser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionsManager
extends UserAwareComponent {
    private final PermissionsService permissionsService;
    private final RapClient rapClient;
    private final LoggingDAO loggingDAO;

    @Autowired
    public PermissionsManager(PermissionsService permissionsService, RapClient rapClient, LoggingDAO loggingDAO) {
        this.permissionsService = permissionsService;
        this.rapClient = rapClient;
        this.loggingDAO = loggingDAO;
    }

    public List<RapUserPermission> getAllPermissions(GroupEntity group) {
        this.verifyUserCanManagePermissions(group);
        List<PermissionEntity> permissions = this.permissionsService.getGroupPermissions(group);
        Set userIdentifiers = permissions.stream().map(p -> p.getUserId()).collect(Collectors.toSet());
        List users = this.rapClient.getUsers(userIdentifiers);
        Map usersMap = users.stream().collect(Collectors.toMap(RapUser::getId, Function.identity()));
        ArrayList<RapUserPermission> result = new ArrayList<RapUserPermission>();
        for (PermissionEntity p2 : permissions) {
            RapUser rapUser = (RapUser)usersMap.get(p2.getUserId());
            if (rapUser == null) continue;
            RapUserPermission permission = new RapUserPermission();
            permission.setPermission(p2.getPermission());
            permission.setUser(rapUser);
            result.add(permission);
        }
        return result;
    }

    public Permission getDirectUserPermission(GroupEntity group, String userId) {
        this.verifyUserCanManagePermissions(group);
        List<PermissionEntity> permissions = this.permissionsService.findUserPermissions(group, userId);
        for (PermissionEntity permission : permissions) {
            if (!permission.getGroupId().equals(group.getId())) continue;
            return permission.getPermission();
        }
        return null;
    }

    public PermissionEntity addPermission(GroupEntity group, String userId, Permission permission) {
        Permission currentUserPermission = this.getCurrentUserPermission(group);
        if (currentUserPermission == Permission.MANAGE_MEMBERS && permission == Permission.VIEW_MEMBERS) {
            return this.permissionsService.addPermission(group, userId, Permission.VIEW_MEMBERS, this.getCurrentUserId());
        }
        if (currentUserPermission == Permission.ADMIN) {
            return this.permissionsService.addPermission(group, userId, permission, this.getCurrentUserId());
        }
        throw this.unauthorizedExceptionSupplier(group).get();
    }

    public PermissionEntity createOrUpdatePermission(GroupEntity group, String userId, Permission permission) {
        this.verifyUserCanManagePermissions(group);
        return this.permissionsService.createOrUpdatePermission(group, userId, permission, this.getCurrentUserId());
    }

    public PermissionEntity updatePermission(GroupEntity group, String userId, Permission permission) {
        this.verifyUserCanManagePermissions(group);
        return this.permissionsService.updatePermission(group, userId, permission, this.getCurrentUserId());
    }

    public void removePermission(GroupEntity group, String userId) {
        Permission currentUserPermission = this.getCurrentUserPermission(group);
        if (currentUserPermission == Permission.MANAGE_MEMBERS) {
            if (this.getUserPermission(group, userId, false) == Permission.VIEW_MEMBERS) {
                this.permissionsService.removePermission(group, userId);
            }
        } else if (currentUserPermission == Permission.ADMIN) {
            this.permissionsService.removePermission(group, userId);
        } else {
            throw this.unauthorizedExceptionSupplier(group).get();
        }
    }

    public List<PermissionEntity> findUserPermissions(GroupEntity group, String userId) {
        this.verifyUserCanManagePermissions(group);
        return this.permissionsService.findUserPermissions(group, userId);
    }

    public Permission getUserPermission(GroupEntity group, String userId) {
        return this.getUserPermission(group, userId, true);
    }

    private Permission getUserPermission(GroupEntity group, String userId, boolean verify) {
        if (verify) {
            this.verifyUserCanManagePermissions(group);
        }
        List<PermissionEntity> permissions = this.permissionsService.findUserPermissions(group, userId);
        return PermissionUtils.getGroupPermission(group, permissions).orElse(null);
    }

    private void verifyUserCanManagePermissions(GroupEntity group) {
        Permission permission = this.getCurrentUserPermission(group);
        if (permission != Permission.ADMIN) {
            throw this.unauthorizedExceptionSupplier(group).get();
        }
    }

    private Supplier<UnauthorizedException> unauthorizedExceptionSupplier(GroupEntity group) {
        this.loggingDAO.logAction(ActionType.UNAUTHORIZED_ACCESS_ATTEMPT, "Unauthorized attempt to manage permissions [group_id=" + group.getId() + "]");
        return () -> new UnauthorizedException("You don't have the privileges for managing the requested permission");
    }

    public List<PermissionEntity> getCurrentUserPermissions() {
        return this.permissionsService.findUserPermissions(this.getCurrentUserId());
    }

    public List<PermissionEntity> getCurrentUserPermissions(GroupEntity group) {
        return this.permissionsService.findUserPermissions(group, this.getCurrentUserId());
    }

    public Permission getCurrentUserPermission(GroupEntity group) {
        List<PermissionEntity> permissions = this.permissionsService.findUserPermissions(group, this.getCurrentUserId());
        return PermissionUtils.getGroupPermission(group, permissions).orElse("ROOT".equals(group.getId()) ? Permission.TRAVERSE : null);
    }
}

