/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.manager;

import it.inaf.ia2.gms.authn.RapClient;
import it.inaf.ia2.gms.exception.UnauthorizedException;
import it.inaf.ia2.gms.manager.PermissionsManager;
import it.inaf.ia2.gms.manager.UserAwareComponent;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.persistence.GroupsDAO;
import it.inaf.ia2.gms.persistence.LoggingDAO;
import it.inaf.ia2.gms.persistence.MembershipsDAO;
import it.inaf.ia2.gms.persistence.model.ActionType;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.persistence.model.MembershipEntity;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import it.inaf.ia2.gms.service.PermissionUtils;
import it.inaf.ia2.rap.data.RapUser;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MembershipManager
extends UserAwareComponent {
    @Autowired
    private MembershipsDAO membershipsDAO;
    @Autowired
    private GroupsDAO groupsDAO;
    @Autowired
    private PermissionsManager permissionsManager;
    @Autowired
    private RapClient rapClient;
    @Autowired
    private LoggingDAO loggingDAO;

    public List<GroupEntity> getCurrentUserMemberships() {
        return this.membershipsDAO.getUserMemberships(this.getCurrentUserId());
    }

    public boolean isCurrentUserMemberOf(String groupId) {
        return this.membershipsDAO.isMemberOf(this.getCurrentUserId(), groupId);
    }

    public List<RapUser> getMembers(GroupEntity group) {
        Permission groupPermission = this.permissionsManager.getCurrentUserPermission(group);
        if (!Permission.includes(groupPermission, Permission.VIEW_MEMBERS)) {
            this.loggingDAO.logAction(ActionType.UNAUTHORIZED_ACCESS_ATTEMPT, "Attempted to view members of group " + group.getId());
            throw new UnauthorizedException("You don't have the permission to view members");
        }
        List<MembershipEntity> memberships = this.membershipsDAO.findByGroup(group.getId());
        Set userIdentifiers = memberships.stream().map(m -> m.getUserId()).collect(Collectors.toSet());
        return this.rapClient.getUsers(userIdentifiers);
    }

    public List<GroupEntity> getUserGroups(GroupEntity parent, String userId) {
        List<PermissionEntity> permissions = this.permissionsManager.getCurrentUserPermissions(parent);
        List<GroupEntity> allGroups = this.membershipsDAO.getUserMemberships(userId, parent.getPath());
        HashSet<String> visibleGroupIds = new HashSet<String>();
        for (GroupEntity group : allGroups) {
            PermissionUtils.getGroupPermission(group, permissions).ifPresent(p -> visibleGroupIds.add(group.getId()));
        }
        return this.groupsDAO.findGroupsByIds(visibleGroupIds);
    }

    public MembershipEntity addMember(GroupEntity group, String userId) {
        this.verifyUserCanManageMembers(group);
        MembershipEntity membership = new MembershipEntity();
        membership.setGroupId(group.getId());
        membership.setUserId(userId);
        membership.setCreatedBy(this.getCurrentUserId());
        membership = this.membershipsDAO.addMember(membership);
        this.loggingDAO.logAction(ActionType.MEMBER_ADDED, "Added member, group_id=" + group.getId() + ", user_id=" + userId);
        return membership;
    }

    public void removeMember(GroupEntity group, String userId) {
        this.verifyUserCanManageMembers(group);
        this.membershipsDAO.removeMembership(group.getId(), userId);
        this.loggingDAO.logAction(ActionType.MEMBER_REMOVED, "Member removed, group_id=" + group.getId() + ", user_id=" + userId);
    }

    private Permission verifyUserCanManageMembers(GroupEntity group) {
        Permission permission = this.permissionsManager.getCurrentUserPermission(group);
        if (!Permission.includes(permission, Permission.MANAGE_MEMBERS)) {
            this.loggingDAO.logAction(ActionType.UNAUTHORIZED_ACCESS_ATTEMPT, "Attempted to manage members of group " + group.getId());
            throw new UnauthorizedException("Missing manage members permissions");
        }
        return permission;
    }
}

