/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.manager;

import it.inaf.ia2.gms.authn.RapClient;
import it.inaf.ia2.gms.exception.BadRequestException;
import it.inaf.ia2.gms.exception.NotFoundException;
import it.inaf.ia2.gms.exception.UnauthorizedException;
import it.inaf.ia2.gms.manager.PermissionsManager;
import it.inaf.ia2.gms.manager.UserAwareComponent;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.response.InvitedRegistrationItem;
import it.inaf.ia2.gms.persistence.GroupsDAO;
import it.inaf.ia2.gms.persistence.InvitedRegistrationDAO;
import it.inaf.ia2.gms.persistence.LoggingDAO;
import it.inaf.ia2.gms.persistence.MembershipsDAO;
import it.inaf.ia2.gms.persistence.model.ActionType;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.persistence.model.InvitedRegistration;
import it.inaf.ia2.gms.persistence.model.MembershipEntity;
import it.inaf.ia2.gms.service.PermissionsService;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvitedRegistrationManager
extends UserAwareComponent {
    private static final String INVITED_REGISTRATION = "invited-registration";
    @Autowired
    private GroupsDAO groupsDAO;
    @Autowired
    private MembershipsDAO membershipsDAO;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private PermissionsManager permissionsManager;
    @Autowired
    private InvitedRegistrationDAO invitedRegistrationDAO;
    @Autowired
    private RapClient rapClient;
    @Autowired
    private HttpServletRequest servletRequest;
    @Autowired
    private LoggingDAO loggingDAO;
    @Autowired(required=false)
    private HttpSession httpSession;

    public void addInvitedRegistration(String tokenHash, String email, Map<GroupEntity, Permission> groupsPermissions) {
        HashMap<String, Permission> groupIdsPermissions = new HashMap<String, Permission>();
        for (Map.Entry<GroupEntity, Permission> entry : groupsPermissions.entrySet()) {
            GroupEntity group = entry.getKey();
            if (this.permissionsManager.getCurrentUserPermission(group) != Permission.ADMIN) {
                this.loggingDAO.logAction(ActionType.UNAUTHORIZED_ACCESS_ATTEMPT, "Attempt to add invited registration for group " + group.getId());
                throw new UnauthorizedException("You don't have the permission to perform invited registrations");
            }
            groupIdsPermissions.put(group.getId(), entry.getValue());
        }
        InvitedRegistration invitedRegistration = new InvitedRegistration().setId(UUID.randomUUID().toString().replaceAll("-", "")).setEmail(email).setTokenHash(tokenHash).setGroupsPermissions(groupIdsPermissions);
        this.invitedRegistrationDAO.addInvitedRegistration(invitedRegistration);
        this.loggingDAO.logAction(ActionType.INVITED_REGISTRATION_ADDED, "Email=" + email);
    }

    public InvitedRegistration getInvitedRegistrationFromToken(String token) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(token.getBytes(StandardCharsets.UTF_8));
            String tokenHash = Base64.getEncoder().encodeToString(hash);
            InvitedRegistration invitedRegistration = this.invitedRegistrationDAO.getInvitedRegistrationFromToken(tokenHash).orElseThrow(() -> new NotFoundException("No invited registrations found for this token"));
            this.httpSession.setAttribute(INVITED_REGISTRATION, (Object)invitedRegistration);
            this.loggingDAO.logAction(ActionType.INVITED_REGISTRATION_OPENED, "Started invited registration for email " + invitedRegistration.getEmail());
            return invitedRegistration;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Optional<List<InvitedRegistration>> completeInvitedRegistrationIfNecessary() {
        List<InvitedRegistration> invitedRegistrations = this.completeInvitedRegistrationIfNecessary(this.servletRequest.getUserPrincipal().getName());
        InvitedRegistration invitedRegistrationFromToken = (InvitedRegistration)this.httpSession.getAttribute(INVITED_REGISTRATION);
        if (invitedRegistrationFromToken != null) {
            boolean alreadyDone = invitedRegistrations.stream().map(reg -> reg.getId()).anyMatch(id -> id.equals(invitedRegistrationFromToken.getId()));
            if (!alreadyDone) {
                this.completeInvitedRegistration(invitedRegistrationFromToken);
                invitedRegistrations.add(invitedRegistrationFromToken);
            }
            this.httpSession.removeAttribute(INVITED_REGISTRATION);
        }
        return Optional.ofNullable(invitedRegistrations.isEmpty() ? null : invitedRegistrations);
    }

    public List<InvitedRegistration> completeInvitedRegistrationIfNecessary(String userId) {
        ArrayList<InvitedRegistration> invitedRegistrations = new ArrayList<InvitedRegistration>();
        List<String> emailAddresses = this.rapClient.getUser(userId).getIdentities().stream().map(identity -> identity.getEmail()).collect(Collectors.toList());
        for (InvitedRegistration invitedRegistration : this.invitedRegistrationDAO.getInvitedRegistrationsFromEmailAddresses(emailAddresses)) {
            this.completeInvitedRegistration(invitedRegistration);
            invitedRegistrations.add(invitedRegistration);
        }
        return invitedRegistrations;
    }

    private void completeInvitedRegistration(InvitedRegistration invitedRegistration) {
        String userId = this.getCurrentUserId();
        for (Map.Entry<String, Permission> entry : invitedRegistration.getGroupsPermissions().entrySet()) {
            String groupId = entry.getKey();
            GroupEntity groupEntity = this.groupsDAO.findGroupById(groupId).get();
            MembershipEntity membershipEntity = new MembershipEntity();
            membershipEntity.setUserId(userId);
            membershipEntity.setGroupId(groupId);
            membershipEntity.setCreatedBy(this.getCurrentUserId());
            this.membershipsDAO.addMember(membershipEntity);
            this.permissionsService.addPermission(groupEntity, userId, entry.getValue(), userId);
        }
        invitedRegistration.setUserId(userId);
        this.invitedRegistrationDAO.setRegistrationDone(invitedRegistration);
        this.loggingDAO.logAction(ActionType.INVITED_REGISTRATION_COMPLETED, "user_id=" + userId + " groups=[" + String.join((CharSequence)",", invitedRegistration.getGroupsPermissions().keySet()) + "]");
    }

    public List<InvitedRegistrationItem> getInvitedRegistrationsForGroup(GroupEntity group) {
        if (this.permissionsManager.getCurrentUserPermission(group) != Permission.ADMIN) {
            return null;
        }
        ArrayList<InvitedRegistrationItem> items = new ArrayList<InvitedRegistrationItem>();
        for (InvitedRegistration reg : this.invitedRegistrationDAO.getPendingInvitedRegistrationsForGroup(group.getId())) {
            Map<String, Permission> map = reg.getGroupsPermissions();
            if (map == null) continue;
            for (Permission permission : map.values()) {
                InvitedRegistrationItem item = new InvitedRegistrationItem().setId(reg.getId()).setEmail(reg.getEmail()).setPermission(permission).setCreationTime(reg.getCreationTime());
                items.add(item);
            }
        }
        return items;
    }

    public void deleteInvitedRegistration(String registrationId, String groupId) {
        GroupEntity group = this.groupsDAO.findGroupById(groupId).orElseThrow(() -> new BadRequestException("No group found for given id: " + groupId));
        if (this.permissionsManager.getUserPermission(group, this.getCurrentUserId()) != Permission.ADMIN) {
            throw new UnauthorizedException("Only administrators can delete invited registrations!");
        }
        this.invitedRegistrationDAO.deleteInvitedRegistrationRequest(registrationId, groupId);
        this.loggingDAO.logAction(ActionType.INVITED_REGISTRATION_DELETED, "Deleted invited registration request. [request_id=" + registrationId + ", group_id=" + groupId + ", group_name=" + group.getName() + "]");
    }
}

