/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.manager;

import it.inaf.ia2.gms.exception.BadRequestException;
import it.inaf.ia2.gms.exception.UnauthorizedException;
import it.inaf.ia2.gms.manager.PermissionsManager;
import it.inaf.ia2.gms.manager.UserAwareComponent;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.persistence.LoggingDAO;
import it.inaf.ia2.gms.persistence.model.ActionType;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import it.inaf.ia2.gms.service.GroupsService;
import it.inaf.ia2.gms.service.PermissionUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class GroupsManager
extends UserAwareComponent {
    private final GroupsService groupsService;
    private final PermissionsManager permissionsManager;
    private final LoggingDAO loggingDAO;

    public GroupsManager(GroupsService groupsService, PermissionsManager permissionsManager, LoggingDAO loggingDAO) {
        this.groupsService = groupsService;
        this.permissionsManager = permissionsManager;
        this.loggingDAO = loggingDAO;
    }

    public GroupEntity getRoot() {
        return this.getGroupById("ROOT");
    }

    public GroupEntity getGroupById(String groupId) {
        GroupEntity group = this.groupsService.getGroupById(groupId);
        this.verifyUserCanReadGroup(group);
        return group;
    }

    public GroupEntity getGroupByPath(String path) {
        GroupEntity group = this.groupsService.getGroupByPath(path);
        this.verifyUserCanReadGroup(group);
        return group;
    }

    public List<GroupEntity> getChildGroups(GroupEntity parentGroup, boolean recursive) {
        List<GroupEntity> allSubGroups = this.groupsService.getChildGroups(parentGroup, recursive);
        List<PermissionEntity> permissions = this.permissionsManager.getCurrentUserPermissions();
        ArrayList<GroupEntity> visibleSubgroups = new ArrayList<GroupEntity>();
        for (GroupEntity subgroup : allSubGroups) {
            PermissionUtils.getGroupPermission(subgroup, permissions).ifPresent(permission -> visibleSubgroups.add(subgroup));
        }
        return visibleSubgroups;
    }

    public GroupEntity createGroup(GroupEntity parent, String childGroupName, boolean leaf) {
        if (parent.isLeaf()) {
            throw new BadRequestException("Unable to create a sub group inside a leaf group");
        }
        this.verifyUserCanManageGroup(parent);
        return this.groupsService.addGroup(parent, childGroupName, leaf, this.getCurrentUserId());
    }

    public GroupEntity updateGroup(String groupId, String newGroupName, boolean leaf) {
        GroupEntity group = this.groupsService.getGroupById(groupId);
        this.verifyUserCanManageGroup(group);
        return this.groupsService.updateGroup(group, newGroupName, leaf);
    }

    public GroupEntity deleteGroup(String groupId) {
        GroupEntity group = this.groupsService.getGroupById(groupId);
        this.verifyUserCanManageGroup(group);
        return this.groupsService.deleteGroup(group);
    }

    public void verifyUserCanReadGroup(GroupEntity group) {
        if ("ROOT".equals(group.getId())) {
            return;
        }
        if (this.permissionsManager.getCurrentUserPermission(group) == null) {
            this.loggingDAO.logAction(ActionType.UNAUTHORIZED_ACCESS_ATTEMPT, "Unauthorized group management request, group_id=" + group.getId());
            throw new UnauthorizedException("Missing permission to see this group");
        }
    }

    private void verifyUserCanManageGroup(GroupEntity group) {
        if (this.permissionsManager.getCurrentUserPermission(group) != Permission.ADMIN) {
            this.loggingDAO.logAction(ActionType.UNAUTHORIZED_ACCESS_ATTEMPT, "Unauthorized group management request, group_id=" + group.getId());
            throw new UnauthorizedException("Missing admin permission");
        }
    }
}

