/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.manager;

import it.inaf.ia2.gms.authn.RapClient;
import it.inaf.ia2.gms.exception.UnauthorizedException;
import it.inaf.ia2.gms.manager.PermissionsManager;
import it.inaf.ia2.gms.manager.UserAwareComponent;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.persistence.GroupsDAO;
import it.inaf.ia2.gms.persistence.MembershipsDAO;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.persistence.model.MembershipEntity;
import it.inaf.ia2.gms.service.GroupsService;
import it.inaf.ia2.rap.data.RapUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupStatusManager
extends UserAwareComponent {
    private static final Logger LOG = LoggerFactory.getLogger(GroupStatusManager.class);
    @Autowired
    private PermissionsManager permissionsManager;
    @Autowired
    private GroupsService groupsService;
    @Autowired
    private GroupsDAO groupsDAO;
    @Autowired
    private MembershipsDAO membershipsDAO;
    @Autowired
    private RapClient rapClient;

    public List<String[]> generateStatus(String groupId) {
        GroupEntity parentGroup = this.groupsService.getGroupById(groupId);
        Permission groupPermission = this.permissionsManager.getCurrentUserPermission(parentGroup);
        if (!Permission.includes(groupPermission, Permission.VIEW_MEMBERS)) {
            throw new UnauthorizedException("VIEW_MEMBERS permission is needed for performing this action");
        }
        List<GroupEntity> groups = this.groupsDAO.getAllChildren(parentGroup.getPath());
        groups.add(parentGroup);
        Map<String, String> names = this.groupsDAO.getGroupCompleteNamesFromId(groups.stream().map(g -> g.getId()).collect(Collectors.toSet()));
        List<MembershipEntity> memberships = this.membershipsDAO.findByGroups(groups.stream().map(g -> g.getId()).collect(Collectors.toList()));
        HashMap<String, ArrayList<String>> membersMap = new HashMap<String, ArrayList<String>>();
        for (MembershipEntity membership : memberships) {
            ArrayList<String> users = (ArrayList<String>)membersMap.get(membership.getGroupId());
            if (users == null) {
                users = new ArrayList<String>();
                membersMap.put(membership.getGroupId(), users);
            }
            users.add(membership.getUserId());
        }
        HashMap<String, String> usersMap = new HashMap<String, String>();
        Set ids = memberships.stream().map(u -> u.getUserId()).collect(Collectors.toSet());
        List usersList = this.rapClient.getUsers(ids);
        for (RapUser user : usersList) {
            usersMap.put(user.getId(), user.getPrimaryEmailAddress());
        }
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (int i = 0; i < groups.size(); ++i) {
            List users;
            GroupEntity group = groups.get(i);
            String groupName = names.get(group.getId());
            if (groupName == null || (users = (List)membersMap.get(group.getId())) == null) continue;
            for (String userId : users) {
                String email = (String)usersMap.get(userId);
                if (email == null) {
                    LOG.warn("Unable to retrieve information about user " + userId);
                    continue;
                }
                String[] row = new String[]{groupName, email};
                rows.add(row);
            }
        }
        Collections.sort(rows, (r1, r2) -> r1[0].compareTo(r2[0]));
        return rows;
    }
}

