/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.exception;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${server.error.path:${error.path:/error}}"})
public class ErrorController
extends AbstractErrorController {
    @Value(value="${support.contact.label}")
    private String supportContactLabel;
    @Value(value="${support.contact.email}")
    private String supportContactEmail;

    @Autowired
    public ErrorController(ErrorAttributes errorAttributes) {
        super(errorAttributes);
    }

    @RequestMapping(produces={"text/html"})
    public void errorHtml(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map errors = super.getErrorAttributes(request, true);
        HttpStatus status = this.getStatus(request);
        String responseText = status == HttpStatus.NOT_FOUND ? this.getFileContent("404.html") : this.getFileContent("error.html").replace("#ERROR_TITLE#", (String)errors.get("error")).replace("#ERROR_MESSAGE#", (String)errors.get("message")).replace("#ADDITIONAL_MESSAGE#", this.getAdditionalMessage(status));
        response.setContentType("text/html;charset=UTF-8");
        response.getOutputStream().print(responseText);
    }

    private String getAdditionalMessage(HttpStatus status) {
        if (status.is5xxServerError()) {
            return "<br/>If you need support please contact <a href=\"mailto:" + this.supportContactEmail + "\">" + this.supportContactLabel + "</a>";
        }
        return "";
    }

    @RequestMapping(produces={"text/plain"})
    public void errorText(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map errors = super.getErrorAttributes(request, true);
        response.setContentType("text/plain;charset=UTF-8");
        response.getOutputStream().print(errors.get("error") + ": " + errors.get("message"));
    }

    @RequestMapping
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        HttpStatus status = this.getStatus(request);
        if (status == HttpStatus.NO_CONTENT) {
            return new ResponseEntity(status);
        }
        Map body = this.getErrorAttributes(request, false);
        return new ResponseEntity((Object)body, status);
    }

    private String getFileContent(String templateFileName) throws IOException {
        try (InputStream in = ErrorController.class.getClassLoader().getResourceAsStream("public/error/" + templateFileName);){
            Scanner s = new Scanner(in).useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }

    public String getErrorPath() {
        return null;
    }
}

