/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.model.request.GenericSearchRequest;
import it.inaf.ia2.gms.model.response.PaginatedData;
import it.inaf.ia2.gms.model.response.SearchResponseItem;
import it.inaf.ia2.gms.model.response.UserSearchResponse;
import it.inaf.ia2.gms.service.SearchService;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SearchController {
    @Autowired
    private HttpServletRequest servletRequest;
    @Autowired
    private SearchService searchService;

    @GetMapping(value={"/ui/search"}, produces={"application/json"})
    public ResponseEntity<PaginatedData<SearchResponseItem>> getSearchResults(@Valid GenericSearchRequest searchRequest) {
        PaginatedData<SearchResponseItem> response = this.searchService.search(searchRequest, this.servletRequest.getUserPrincipal().getName());
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/ui/search/user/{userId}"}, produces={"application/json"})
    public ResponseEntity<UserSearchResponse> getSearchResultUser(@PathVariable(value="userId") String userId) {
        UserSearchResponse response = this.searchService.getUserSearchResult(this.servletRequest.getUserPrincipal().getName(), userId);
        return ResponseEntity.ok((Object)response);
    }
}

