/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.manager.GroupsManager;
import it.inaf.ia2.gms.manager.PermissionsManager;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.RapUserPermission;
import it.inaf.ia2.gms.model.request.AddPermissionRequest;
import it.inaf.ia2.gms.model.request.MemberRequest;
import it.inaf.ia2.gms.model.request.PaginatedModelRequest;
import it.inaf.ia2.gms.model.request.TabRequest;
import it.inaf.ia2.gms.model.request.UpdatePermissionRequest;
import it.inaf.ia2.gms.model.response.PaginatedData;
import it.inaf.ia2.gms.model.response.UserPermission;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import it.inaf.ia2.gms.service.GroupNameService;
import it.inaf.ia2.gms.service.SearchService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PermissionsController {
    @Autowired
    private GroupsManager groupsManager;
    @Autowired
    private PermissionsManager permissionsManager;
    @Autowired
    protected GroupNameService groupNameService;
    @Autowired
    private SearchService searchService;

    @GetMapping(value={"/ui/permissions"}, produces={"application/json"})
    public ResponseEntity<PaginatedData<RapUserPermission>> getPermissionsTab(TabRequest request) {
        GroupEntity group = this.groupsManager.getGroupById(request.getGroupId());
        PaginatedData<RapUserPermission> permissionsPanel = this.getPermissionsPanel(group, request);
        return ResponseEntity.ok(permissionsPanel);
    }

    @GetMapping(value={"/ui/permission"}, produces={"application/json"})
    public ResponseEntity<Map<String, Permission>> getUserPermission(@RequestParam(value="groupId") String groupId, @RequestParam(value="userId") String userId) {
        GroupEntity group = this.groupsManager.getGroupById(groupId);
        Permission permission = this.permissionsManager.getDirectUserPermission(group, userId);
        if (permission == null) {
            return ResponseEntity.noContent().build();
        }
        HashMap<String, Permission> response = new HashMap<String, Permission>();
        response.put("permission", permission);
        return ResponseEntity.ok(response);
    }

    @PostMapping(value={"/ui/permission"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<PaginatedData<RapUserPermission>> addPermission(@Valid @RequestBody AddPermissionRequest request) {
        GroupEntity group = this.groupsManager.getGroupById(request.getGroupId());
        if (request.isOverride()) {
            this.permissionsManager.updatePermission(group, request.getUserId(), request.getPermission());
        } else {
            this.permissionsManager.addPermission(group, request.getUserId(), request.getPermission());
        }
        return new ResponseEntity(this.getPermissionsPanel(group, request), HttpStatus.CREATED);
    }

    @PutMapping(value={"/ui/permission"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<Map<String, String>> updatePermission(@Valid @RequestBody UpdatePermissionRequest request) {
        GroupEntity group = this.groupsManager.getGroupById(request.getGroupId());
        PermissionEntity updatedEntity = this.permissionsManager.updatePermission(group, request.getUserId(), request.getPermission());
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("permission", updatedEntity.getPermission().toString());
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/ui/permission"}, produces={"application/json"})
    public ResponseEntity<PaginatedData<RapUserPermission>> deletePermission(@Valid MemberRequest request) {
        GroupEntity group = this.groupsManager.getGroupById(request.getGroupId());
        this.permissionsManager.removePermission(group, request.getUserId());
        return ResponseEntity.ok(this.getPermissionsPanel(group, request));
    }

    private PaginatedData<RapUserPermission> getPermissionsPanel(GroupEntity group, PaginatedModelRequest request) {
        List<RapUserPermission> permissions = this.permissionsManager.getAllPermissions(group);
        Collections.sort(permissions, (p1, p2) -> p1.getUser().getDisplayName().compareTo(p2.getUser().getDisplayName()));
        return new PaginatedData<RapUserPermission>(permissions, request.getPaginatorPage(), request.getPaginatorPageSize());
    }

    @GetMapping(value={"/permission"}, produces={"text/plain"})
    public void getUserPermission(@RequestParam(value="group") Optional<String> groupNames, @RequestParam(value="user_id") Optional<String> userId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        GroupEntity groupEntity = this.groupNameService.getGroupFromNames(groupNames);
        if (userId.isPresent()) {
            if (userId.get().equals(request.getUserPrincipal().getName())) {
                try (PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());){
                    List<PermissionEntity> userPermissions = this.permissionsManager.getCurrentUserPermissions();
                    Map<String, List<String>> namesMap = this.groupNameService.getNamesFromIds(userPermissions.stream().map(pe -> pe.getGroupId()).collect(Collectors.toSet()));
                    for (PermissionEntity pe2 : userPermissions) {
                        pw.println(this.groupNameService.getCompleteName(namesMap.get(pe2.getGroupId())) + " " + (Object)((Object)pe2.getPermission()));
                    }
                }
            } else {
                try (PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());){
                    for (UserPermission userPermission : this.searchService.getUserPermission(groupEntity, userId.get(), this.permissionsManager.getCurrentUserPermissions(groupEntity))) {
                        String group = this.groupNameService.getCompleteName(userPermission.getGroupCompleteName());
                        pw.println(group + " " + (Object)((Object)userPermission.getPermission()));
                    }
                }
            }
        } else {
            try (PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());){
                for (RapUserPermission up : this.permissionsManager.getAllPermissions(groupEntity)) {
                    pw.println(up.getUser().getId() + " " + (Object)((Object)up.getPermission()));
                }
            }
        }
    }

    @PostMapping(value={"/permission"}, produces={"text/plain"}, consumes={"application/x-www-form-urlencoded"})
    public void addPermission(@RequestParam(value="group") Optional<String> groupNames, @RequestParam(value="user_id") String targetUserId, @RequestParam(value="permission") Permission permission) throws IOException {
        GroupEntity groupEntity = this.groupNameService.getGroupFromNames(groupNames);
        this.permissionsManager.addPermission(groupEntity, targetUserId, permission);
    }

    @PutMapping(value={"/permission"}, produces={"text/plain"}, consumes={"application/x-www-form-urlencoded"})
    public void setPermission(@RequestParam(value="group") Optional<String> groupNames, @RequestParam(value="user_id") String targetUserId, @RequestParam(value="permission") Permission permission) throws IOException {
        GroupEntity groupEntity = this.groupNameService.getGroupFromNames(groupNames);
        this.permissionsManager.createOrUpdatePermission(groupEntity, targetUserId, permission);
    }

    @DeleteMapping(value={"/permission"}, produces={"text/plain"})
    public ResponseEntity<?> removePermission(@RequestParam(value="group") Optional<String> groupNames, @RequestParam(value="user_id") String userId) {
        GroupEntity groupEntity = this.groupNameService.getGroupFromNames(groupNames);
        this.permissionsManager.removePermission(groupEntity, userId);
        return ResponseEntity.noContent().build();
    }
}

