/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.authn.RapPrincipal;
import it.inaf.ia2.gms.exception.BadRequestException;
import it.inaf.ia2.gms.manager.GroupsManager;
import it.inaf.ia2.gms.manager.InvitedRegistrationManager;
import it.inaf.ia2.gms.manager.MembershipManager;
import it.inaf.ia2.gms.manager.PermissionsManager;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.RapUserPermission;
import it.inaf.ia2.gms.model.response.UserPermission;
import it.inaf.ia2.gms.persistence.GroupsDAO;
import it.inaf.ia2.gms.persistence.PermissionsDAO;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.persistence.model.InvitedRegistration;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import it.inaf.ia2.gms.service.GroupNameService;
import it.inaf.ia2.gms.service.GroupsService;
import it.inaf.ia2.gms.service.JoinService;
import it.inaf.ia2.gms.service.PermissionUtils;
import it.inaf.ia2.gms.service.SearchService;
import it.inaf.ia2.rap.data.RapUser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JWTWebServiceController {
    @Autowired
    private JoinService joinService;
    @Autowired
    private GroupsDAO groupsDAO;
    @Autowired
    private GroupsManager groupsManager;
    @Autowired
    private GroupsService groupsService;
    @Autowired
    protected GroupNameService groupNameService;
    @Autowired
    private MembershipManager membershipManager;
    @Autowired
    private PermissionsManager permissionsManager;
    @Autowired
    private PermissionsDAO permissionsDAO;
    @Autowired
    private SearchService searchService;
    @Autowired
    private InvitedRegistrationManager invitedRegistrationManager;

    @GetMapping(value={"/ws/jwt/search", "/vo/search"}, produces={"text/plain"})
    public void getGroups(HttpServletResponse response) throws IOException {
        List<GroupEntity> memberships = this.membershipManager.getCurrentUserMemberships();
        List<String> names = this.groupNameService.getGroupsNames(memberships);
        try (PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());){
            for (String name : names) {
                pw.println(name);
            }
        }
    }

    @GetMapping(value={"/ws/jwt/search/**", "/vo/search/**"}, produces={"text/plain"})
    public void isMemberOf(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String groupNamesString = this.getGroupFromRequest(request, "/ws/jwt/search/", "/vo/search/");
        List<String> groupNames = this.groupNameService.extractGroupNames(groupNamesString);
        ArrayList<String> existingGroupNames = new ArrayList<String>();
        GroupEntity group = null;
        String parentPath = "";
        for (String groupName : groupNames) {
            Optional<GroupEntity> optionalGroup = this.groupsDAO.findGroupByParentAndName(parentPath, groupName);
            if (!optionalGroup.isPresent()) continue;
            GroupEntity groupEntity = optionalGroup.get();
            parentPath = groupEntity.getPath();
            existingGroupNames.add(groupName);
            boolean isMember = this.membershipManager.isCurrentUserMemberOf(groupEntity.getId());
            if (!isMember) continue;
            group = groupEntity;
        }
        if (group != null) {
            try (PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());){
                pw.println(this.groupNameService.getCompleteName(existingGroupNames));
            }
        }
    }

    @GetMapping(value={"/ws/jwt/list/{group:.+}", "/ws/jwt/list", "/list", "/list/{group:.+}"}, produces={"text/plain"})
    public void listGroups(@PathVariable(value="group") Optional<String> groupNames, @RequestParam(value="recursive", defaultValue="false") boolean recursive, Principal principal, HttpServletResponse response) throws IOException {
        String userId = principal.getName();
        GroupEntity parentGroup = this.groupNameService.getGroupFromNames(groupNames);
        List<GroupEntity> allSubGroups = recursive ? this.groupsDAO.getAllChildren(parentGroup.getPath()) : this.groupsDAO.getDirectSubGroups(parentGroup.getPath());
        List<PermissionEntity> permissions = this.permissionsDAO.findUserPermissions(userId);
        ArrayList<GroupEntity> visibleSubgroups = new ArrayList<GroupEntity>();
        for (GroupEntity subgroup : allSubGroups) {
            PermissionUtils.getGroupPermission(subgroup, permissions).ifPresent(permission -> visibleSubgroups.add(subgroup));
        }
        try (PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());){
            for (String groupName : this.groupNameService.getGroupsNames(visibleSubgroups)) {
                pw.println(this.groupNameService.getShortGroupName(groupName, groupNames));
            }
        }
    }

    @Deprecated
    @PostMapping(value={"/ws/jwt/{group:.+}"}, produces={"text/plain"})
    public void createGroup(@PathVariable(value="group") String groupParam, HttpServletRequest request, HttpServletResponse response) throws IOException {
        List<String> groupNames = this.groupNameService.extractGroupNames(groupParam);
        String leafParam = request.getParameter("leaf");
        boolean leaf = leafParam == null ? false : Boolean.valueOf(leafParam);
        GroupEntity group = this.groupsManager.getRoot();
        for (int i = 0; i < groupNames.size(); ++i) {
            String name = groupNames.get(i);
            Optional<GroupEntity> optGroup = this.groupsService.findGroupByParentAndName(group, name);
            group = optGroup.isPresent() ? optGroup.get() : this.groupsManager.createGroup(group, name, i == groupNames.size() - 1 ? leaf : false);
        }
        response.setStatus(201);
        try (PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());){
            pw.println(groupParam);
        }
    }

    @Deprecated
    @DeleteMapping(value={"/ws/jwt/{group:.+}"}, produces={"text/plain"})
    public void deleteGroup(@PathVariable(value="group") String groupParam, HttpServletResponse response) {
        GroupEntity group = this.groupNameService.getGroupFromNames(Optional.of(groupParam));
        this.groupsManager.deleteGroup(group.getId());
        response.setStatus(204);
    }

    @Deprecated
    @GetMapping(value={"/ws/jwt/membership/{group:.+}", "/ws/jwt/membership"}, produces={"text/plain"})
    public void getMembership(@PathVariable(value="group") Optional<String> groupNames, @RequestParam(value="user_id") String userId, HttpServletResponse response) throws IOException {
        GroupEntity parent = this.groupNameService.getGroupFromNames(groupNames);
        List<GroupEntity> groups = this.membershipManager.getUserGroups(parent, userId);
        try (PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());){
            for (String groupName : this.groupNameService.getGroupsNames(groups)) {
                pw.println(this.groupNameService.getShortGroupName(groupName, groupNames));
            }
        }
    }

    @Deprecated
    @PostMapping(value={"/ws/jwt/membership/{group:.+}", "/ws/jwt/membership"}, produces={"text/plain"})
    public void addMember(@PathVariable(value="group") Optional<String> groupNames, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String targetUserId = request.getParameter("user_id");
        if (targetUserId == null) {
            response.sendError(400, "Missing user_id parameter");
            return;
        }
        GroupEntity groupEntity = this.groupNameService.getGroupFromNames(groupNames);
        this.membershipManager.addMember(groupEntity, targetUserId);
    }

    @Deprecated
    @DeleteMapping(value={"/ws/jwt/membership/{group:.+}", "/ws/jwt/membership"}, produces={"text/plain"})
    public void removeMember(@PathVariable(value="group") Optional<String> groupNames, @RequestParam(value="user_id") String userId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        GroupEntity groupEntity = this.groupNameService.getGroupFromNames(groupNames);
        this.membershipManager.removeMember(groupEntity, userId);
        response.setStatus(204);
    }

    @Deprecated
    @GetMapping(value={"/ws/jwt/permission/{group:.+}", "/ws/jwt/permission"}, produces={"text/plain"})
    public void getUserPermission(@PathVariable(value="group") Optional<String> groupNames, @RequestParam(value="user_id") Optional<String> userId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        GroupEntity groupEntity = this.groupNameService.getGroupFromNames(groupNames);
        if (userId.isPresent()) {
            try (PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());){
                for (UserPermission userPermission : this.searchService.getUserPermission(groupEntity, userId.get(), this.permissionsManager.getCurrentUserPermissions(groupEntity))) {
                    String group = this.groupNameService.getCompleteName(userPermission.getGroupCompleteName());
                    pw.println(group + " " + (Object)((Object)userPermission.getPermission()));
                }
            }
        }
        try (PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());){
            for (RapUserPermission up : this.permissionsManager.getAllPermissions(groupEntity)) {
                pw.println(up.getUser().getId() + " " + (Object)((Object)up.getPermission()));
            }
        }
    }

    @Deprecated
    @PostMapping(value={"/ws/jwt/permission/{group:.+}", "/ws/jwt/permission/"}, produces={"text/plain"}, consumes={"application/x-www-form-urlencoded"})
    public void addPermission(@PathVariable(value="group") Optional<String> groupNames, @RequestParam(value="user_id") String targetUserId, @RequestParam(value="permission") Permission permission) throws IOException {
        GroupEntity groupEntity = this.groupNameService.getGroupFromNames(groupNames);
        this.permissionsManager.addPermission(groupEntity, targetUserId, permission);
    }

    @Deprecated
    @PutMapping(value={"/ws/jwt/permission/{group:.+}", "/ws/jwt/permission/"}, produces={"text/plain"}, consumes={"application/x-www-form-urlencoded"})
    public void setPermission(@PathVariable(value="group") Optional<String> groupNames, @RequestParam(value="user_id") String targetUserId, @RequestParam(value="permission") Permission permission) throws IOException {
        GroupEntity groupEntity = this.groupNameService.getGroupFromNames(groupNames);
        this.permissionsManager.createOrUpdatePermission(groupEntity, targetUserId, permission);
    }

    @Deprecated
    @DeleteMapping(value={"/ws/jwt/permission/{group:.+}", "/ws/jwt/permission/"}, produces={"text/plain"})
    public void removePermission(@PathVariable(value="group") Optional<String> groupNames, @RequestParam(value="user_id") String userId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        GroupEntity groupEntity = this.groupNameService.getGroupFromNames(groupNames);
        this.permissionsManager.removePermission(groupEntity, userId);
        response.setStatus(204);
    }

    @GetMapping(value={"/ws/jwt/check-invited-registration", "/check-invited-registration"}, produces={"text/plain"})
    public void completeInvitedRegistrationIfNecessary(Principal principal, HttpServletResponse response) throws IOException {
        String userId = principal.getName();
        HashSet<String> groupIds = new HashSet<String>();
        for (InvitedRegistration invitedRegistration : this.invitedRegistrationManager.completeInvitedRegistrationIfNecessary(userId)) {
            groupIds.addAll(invitedRegistration.getGroupsPermissions().keySet());
        }
        List<GroupEntity> groups = this.groupsDAO.findGroupsByIds(groupIds);
        if (!groups.isEmpty()) {
            List<String> names = this.groupNameService.getGroupsNames(groups);
            try (PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());){
                for (String name : names) {
                    pw.println(name);
                }
            }
        }
    }

    @PostMapping(value={"/ws/jwt/invited-registration", "/invited-registration"}, produces={"text/plain"})
    public void addInvitedRegistration(@RequestParam(value="token_hash") String tokenHash, @RequestParam(value="email") String email, @RequestParam(value="groups") String groupNamesAndPermissionsParam, HttpServletResponse response) {
        HashMap<GroupEntity, Permission> groupsPermissions = new HashMap<GroupEntity, Permission>();
        for (String param : groupNamesAndPermissionsParam.split("\n")) {
            if (param.isEmpty()) continue;
            int lastSpaceIndex = param.lastIndexOf(" ");
            String groupName = param.substring(0, lastSpaceIndex);
            Permission permission = Permission.valueOf(param.substring(lastSpaceIndex + 1));
            GroupEntity groupEntity = this.groupNameService.getGroupFromNames(Optional.of(groupName));
            groupsPermissions.put(groupEntity, permission);
        }
        this.invitedRegistrationManager.addInvitedRegistration(tokenHash, email, groupsPermissions);
        response.setStatus(201);
    }

    @GetMapping(value={"/ws/jwt/email/**", "/email/**"}, produces={"text/plain"})
    public void getEmailOfMembers(HttpServletRequest request, @RequestParam(value="permission") Optional<Permission> permission, HttpServletResponse response) throws IOException {
        String groupNames = this.getGroupFromRequest(request, "/ws/jwt/email/", "/email/");
        GroupEntity groupEntity = this.groupNameService.getGroupFromNames(Optional.of(groupNames));
        HashSet<String> selectedUserIds = null;
        if (permission.isPresent()) {
            Permission desiredPermission = permission.get();
            selectedUserIds = new HashSet<String>();
            for (PermissionEntity groupsPermission : this.permissionsDAO.getGroupsPermissions(groupEntity.getId())) {
                if (!Permission.includes(groupsPermission.getPermission(), desiredPermission)) continue;
                selectedUserIds.add(groupsPermission.getUserId());
            }
        }
        try (PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());){
            for (RapUser member : this.membershipManager.getMembers(groupEntity)) {
                if (selectedUserIds != null && !selectedUserIds.contains(member.getId())) continue;
                pw.println(member.getPrimaryEmailAddress());
            }
        }
    }

    @PostMapping(value={"/ws/jwt/join", "/join"}, produces={"application/json"})
    public ResponseEntity<?> join(RapPrincipal principal) {
        String fromUser = principal.getName();
        String toUser = principal.getAlternativeName();
        if (toUser == null) {
            throw new BadRequestException("Missing alternative subject");
        }
        String mergedId = this.joinService.join(fromUser, toUser);
        HashMap<String, String> responseBody = new HashMap<String, String>();
        responseBody.put("mergedId", mergedId);
        return ResponseEntity.ok(responseBody);
    }

    private String getGroupFromRequest(HttpServletRequest request, String ... basePaths) {
        for (String basePath : basePaths) {
            String completeBasePath = request.getContextPath() + basePath;
            if (!request.getRequestURI().startsWith(completeBasePath)) continue;
            return URLDecoder.decode(request.getRequestURI().substring(completeBasePath.length()), StandardCharsets.UTF_8);
        }
        return "";
    }
}

