/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.manager.InvitedRegistrationManager;
import it.inaf.ia2.gms.persistence.model.InvitedRegistration;
import it.inaf.ia2.gms.service.GroupNameService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Controller
public class InvitedRegistrationController {
    @Autowired
    private InvitedRegistrationManager invitedRegistrationManager;
    @Autowired
    private GroupNameService groupNameService;

    @GetMapping(value={"/invited-registration"}, produces={"text/html"})
    public void index(@RequestParam(value="token") String token, HttpServletRequest request, HttpServletResponse response) throws IOException {
        InvitedRegistration invitedRegistration = this.invitedRegistrationManager.getInvitedRegistrationFromToken(token);
        String html = this.getFileContent("invited-registration.html").replace("#EMAIL#", invitedRegistration.getEmail()).replace("#GROUPS#", this.getGroupsList(Collections.singletonList(invitedRegistration))).replace("#HOME#", request.getContextPath());
        response.getOutputStream().print(html);
    }

    @GetMapping(value={"/registration-completed"}, produces={"text/html"})
    public void completed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        List invitedRegistrations = (List)request.getAttribute("invited-registrations");
        if (invitedRegistrations == null) {
            String baseUrl = ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString();
            response.sendRedirect(baseUrl);
        } else {
            String html = this.getFileContent("registration-completed.html").replace("#GROUPS#", this.getGroupsList(invitedRegistrations)).replace("#HOME#", request.getContextPath());
            response.getOutputStream().print(html);
        }
    }

    @DeleteMapping(value={"/ui/registration"}, produces={"application/json"})
    public ResponseEntity<?> deleteInvitedRegistration(@RequestParam(value="request_id") String requestId, @RequestParam(value="group_id") String groupId) {
        this.invitedRegistrationManager.deleteInvitedRegistration(requestId, groupId);
        return ResponseEntity.noContent().build();
    }

    private String getFileContent(String templateFileName) throws IOException {
        try (InputStream in = InvitedRegistrationController.class.getClassLoader().getResourceAsStream("templates/" + templateFileName);){
            Scanner s = new Scanner(in).useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }

    private String getGroupsList(List<InvitedRegistration> invitedRegistrations) {
        String groups = "<ul>";
        for (InvitedRegistration invitedRegistration : invitedRegistrations) {
            for (String groupName : this.groupNameService.getGroupsNamesFromIdentifiers(invitedRegistration.getGroupsPermissions().keySet())) {
                groups = groups + "<li>" + groupName + "</li>";
            }
        }
        groups = groups + "</ul>";
        return groups;
    }
}

