/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.opencsv.CSVWriter;
import it.inaf.ia2.gms.controller.GroupsTabResponseBuilder;
import it.inaf.ia2.gms.manager.GroupStatusManager;
import it.inaf.ia2.gms.manager.GroupsManager;
import it.inaf.ia2.gms.model.GroupNode;
import it.inaf.ia2.gms.model.request.AddGroupRequest;
import it.inaf.ia2.gms.model.request.DeleteGroupRequest;
import it.inaf.ia2.gms.model.request.GroupsRequest;
import it.inaf.ia2.gms.model.request.PaginatedModelRequest;
import it.inaf.ia2.gms.model.request.RenameGroupRequest;
import it.inaf.ia2.gms.model.response.PaginatedData;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.service.GroupNameService;
import it.inaf.ia2.gms.service.GroupsService;
import it.inaf.ia2.gms.service.GroupsTreeBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GroupsController {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    @Autowired
    private HttpServletRequest servletRequest;
    @Autowired
    private GroupsManager groupsManager;
    @Autowired
    private GroupsService groupsService;
    @Autowired
    private GroupsTreeBuilder groupsTreeBuilder;
    @Autowired
    private GroupsTabResponseBuilder groupsTabResponseBuilder;
    @Autowired
    private GroupStatusManager groupStatusManager;
    @Autowired
    protected GroupNameService groupNameService;

    @GetMapping(value={"/ui/groups"}, produces={"application/json"})
    public ResponseEntity<?> getGroupsTab(@Valid GroupsRequest request) {
        if (request.isOnlyPanel()) {
            GroupEntity group = this.groupsManager.getGroupById(request.getGroupId());
            return ResponseEntity.ok(this.getGroupsPanel(group, request));
        }
        return ResponseEntity.ok((Object)this.groupsTabResponseBuilder.getGroupsTab(request));
    }

    @PostMapping(value={"/ui/group"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<PaginatedData<GroupNode>> createGroup(@Valid @RequestBody AddGroupRequest request) {
        GroupEntity parent = this.groupsManager.getGroupById(request.getParentGroupId());
        this.groupsManager.createGroup(parent, request.getNewGroupName(), request.isLeaf());
        PaginatedData<GroupNode> groupsPanel = this.getGroupsPanel(parent, request);
        return new ResponseEntity(groupsPanel, HttpStatus.CREATED);
    }

    @PutMapping(value={"/ui/group/{groupId}"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<PaginatedData<GroupNode>> updateGroup(@PathVariable(value="groupId") String groupId, @Valid @RequestBody RenameGroupRequest request) {
        GroupEntity updatedGroup = this.groupsManager.updateGroup(groupId, request.getNewGroupName(), request.isLeaf());
        GroupEntity parent = this.groupsManager.getGroupByPath(updatedGroup.getParentPath());
        PaginatedData<GroupNode> groupsPanel = this.getGroupsPanel(parent, request);
        return ResponseEntity.ok(groupsPanel);
    }

    @DeleteMapping(value={"/ui/group/{groupId}"}, produces={"application/json"})
    public ResponseEntity<PaginatedData<GroupNode>> deleteGroup(@PathVariable(value="groupId") String groupId, DeleteGroupRequest request) {
        GroupEntity parent = this.groupsManager.deleteGroup(groupId);
        PaginatedData<GroupNode> groupsPanel = this.getGroupsPanel(parent, request);
        return ResponseEntity.ok(groupsPanel);
    }

    @GetMapping(value={"/group/status"}, produces={"application/octet-stream", "application/json"})
    public void downloadStatus(@RequestParam(value="groupId", required=false) String groupId, @RequestParam(value="groupName", required=false) String groupName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block15: {
            if (groupId == null && groupName == null) {
                response.sendError(400, "Parameter groupId or groupName is required");
                return;
            }
            if (groupId == null) {
                GroupEntity group = this.groupNameService.getGroupFromNames(Optional.of(groupName));
                groupId = group.getId();
            }
            List<String[]> status = this.groupStatusManager.generateStatus(groupId);
            try (ServletOutputStream out = response.getOutputStream();){
                if ("application/json".equals(request.getHeader("Accept"))) {
                    MAPPER.writeValue((OutputStream)out, status);
                    break block15;
                }
                try (CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)out));){
                    writer.writeNext(new String[]{"program", "email"});
                    for (String[] row : status) {
                        writer.writeNext(row);
                    }
                }
            }
        }
    }

    private <T extends PaginatedModelRequest> PaginatedData<GroupNode> getGroupsPanel(GroupEntity parentGroup, T request) {
        return this.groupsTreeBuilder.listSubGroups(parentGroup, request, this.servletRequest.getUserPrincipal().getName());
    }

    @GetMapping(value={"/groups"}, produces={"text/plain"})
    public void listChildGroups(@RequestParam(value="parent") Optional<String> groupNames, @RequestParam(value="recursive", defaultValue="false") boolean recursive, Principal principal, HttpServletResponse response) throws IOException {
        GroupEntity parentGroup = this.groupNameService.getGroupFromNames(groupNames);
        List<GroupEntity> visibleSubgroups = this.groupsManager.getChildGroups(parentGroup, recursive);
        try (PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());){
            for (String groupName : this.groupNameService.getGroupsNames(visibleSubgroups)) {
                pw.println(this.groupNameService.getShortGroupName(groupName, groupNames));
            }
        }
    }

    @PostMapping(value={"/group"}, produces={"text/plain"}, consumes={"application/x-www-form-urlencoded"})
    public void createGroup(@RequestParam(value="name") String groupParam, @RequestParam(value="leaf", required=false, defaultValue="false") boolean leaf, HttpServletResponse response) throws IOException {
        List<String> groupNames = this.groupNameService.extractGroupNames(groupParam);
        GroupEntity group = this.groupsManager.getRoot();
        for (int i = 0; i < groupNames.size(); ++i) {
            String name = groupNames.get(i);
            Optional<GroupEntity> optGroup = this.groupsService.findGroupByParentAndName(group, name);
            group = optGroup.isPresent() ? optGroup.get() : this.groupsManager.createGroup(group, name, i == groupNames.size() - 1 ? leaf : false);
        }
        response.setStatus(201);
        try (PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());){
            pw.println(groupParam);
        }
    }

    @DeleteMapping(value={"/group"}, produces={"text/plain"})
    public ResponseEntity<?> deleteGroup(@RequestParam(value="name") String groupParam) {
        GroupEntity group = this.groupNameService.getGroupFromNames(Optional.of(groupParam));
        this.groupsManager.deleteGroup(group.getId());
        return ResponseEntity.noContent().build();
    }
}

