/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.authn;

import it.inaf.ia2.aa.UserManager;
import it.inaf.ia2.gms.authn.GmsLoginFilter;
import it.inaf.ia2.gms.authn.JWTFilter;
import it.inaf.ia2.gms.persistence.LoggingDAO;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class SecurityConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityConfig.class);
    @Value(value="${cors.allowed.origin}")
    private String corsAllowedOrigin;

    @Bean
    @Profile(value={"dev"})
    public WebMvcConfigurer corsConfigurer() {
        return new WebMvcConfigurer(){

            public void addCorsMappings(CorsRegistry registry) {
                LOG.warn("Development profile active: CORS filter enabled");
                registry.addMapping("/**").allowedOrigins(new String[]{SecurityConfig.this.corsAllowedOrigin}).allowedMethods(new String[]{"*"}).allowCredentials(true);
            }
        };
    }

    @Bean
    public FilterRegistrationBean serviceJWTFilter(LoggingDAO loggingDAO, UserManager userManager) {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new JWTFilter(loggingDAO, userManager));
        bean.addUrlPatterns(new String[]{"/*"});
        bean.setOrder(Integer.MIN_VALUE);
        return bean;
    }

    @Bean
    public FilterRegistrationBean loginFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new GmsLoginFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        return registration;
    }

    @Bean
    public RestTemplate rapRestTemplate() {
        return new RestTemplate();
    }
}

