/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.persistence.LoggingDAO;
import it.inaf.ia2.gms.persistence.PermissionsDAO;
import it.inaf.ia2.gms.persistence.model.ActionType;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionsService {
    private final PermissionsDAO permissionsDAO;
    private final LoggingDAO loggingDAO;

    @Autowired
    public PermissionsService(PermissionsDAO permissionsDAO, LoggingDAO loggingDAO) {
        this.permissionsDAO = permissionsDAO;
        this.loggingDAO = loggingDAO;
    }

    public List<PermissionEntity> getGroupPermissions(GroupEntity group) {
        return this.permissionsDAO.getGroupsPermissions(group.getId());
    }

    public List<PermissionEntity> findUserPermissions(String userId) {
        return this.permissionsDAO.findUserPermissions(userId);
    }

    public List<PermissionEntity> findUserPermissions(GroupEntity group, String userId) {
        return this.permissionsDAO.findUserPermissions(userId, group.getPath());
    }

    public void removePermission(GroupEntity group, String userId) {
        this.permissionsDAO.deletePermission(group.getId(), userId);
        this.loggingDAO.logAction(ActionType.PERMISSION_REMOVED, "Removed permission for " + userId + " in group " + group.getId());
    }

    public PermissionEntity addPermission(GroupEntity group, String userId, Permission permission, String setBy) {
        PermissionEntity permissionEntity;
        Optional<PermissionEntity> existingPermissionEntity = this.permissionsDAO.findPermissionEntity(group.getId(), userId);
        if (existingPermissionEntity.isPresent()) {
            permissionEntity = existingPermissionEntity.get();
            Permission resultingPermission = Permission.addPermission(permissionEntity.getPermission(), permission);
            if (resultingPermission == permissionEntity.getPermission()) {
                return permissionEntity;
            }
            permissionEntity.setPermission(resultingPermission);
        } else {
            permissionEntity = new PermissionEntity();
            permissionEntity.setGroupId(group.getId());
            permissionEntity.setUserId(userId);
            permissionEntity.setPermission(permission);
            permissionEntity.setGroupPath(group.getPath());
            permissionEntity.setSetBy(setBy);
        }
        permissionEntity = this.permissionsDAO.createOrUpdatePermission(permissionEntity);
        this.loggingDAO.logAction(ActionType.PERMISSION_ADDED, "Added " + (Object)((Object)permission) + " permission for " + userId + " in group " + group.getId());
        return permissionEntity;
    }

    public PermissionEntity createOrUpdatePermission(GroupEntity group, String userId, Permission permission, String setBy) {
        PermissionEntity permissionEntity = new PermissionEntity();
        permissionEntity.setGroupId(group.getId());
        permissionEntity.setUserId(userId);
        permissionEntity.setPermission(permission);
        permissionEntity.setGroupPath(group.getPath());
        permissionEntity.setSetBy(setBy);
        permissionEntity = this.permissionsDAO.createOrUpdatePermission(permissionEntity);
        this.loggingDAO.logAction(ActionType.PERMISSION_ADDED, "Added " + (Object)((Object)permission) + " permission for " + userId + " in group " + group.getId());
        return permissionEntity;
    }

    public PermissionEntity updatePermission(GroupEntity group, String userId, Permission permission, String setBy) {
        PermissionEntity permissionEntity = this.permissionsDAO.findPermissionEntity(group.getId(), userId).orElseThrow(() -> new IllegalArgumentException("Specified permission not found"));
        permissionEntity.setSetBy(setBy);
        permissionEntity.setPermission(permission);
        permissionEntity = this.permissionsDAO.updatePermission(permissionEntity);
        this.loggingDAO.logAction(ActionType.PERMISSION_UPDATED, "Updated permission for " + userId + " in group " + group.getId() + " to " + (Object)((Object)permission));
        return permissionEntity;
    }
}

