/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.exception.BadRequestException;
import it.inaf.ia2.gms.exception.UnauthorizedException;
import it.inaf.ia2.gms.model.GroupBreadcrumb;
import it.inaf.ia2.gms.persistence.GroupsDAO;
import it.inaf.ia2.gms.persistence.InvitedRegistrationDAO;
import it.inaf.ia2.gms.persistence.LoggingDAO;
import it.inaf.ia2.gms.persistence.MembershipsDAO;
import it.inaf.ia2.gms.persistence.PermissionsDAO;
import it.inaf.ia2.gms.persistence.model.ActionType;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupsService {
    public static final String ROOT = "ROOT";
    private final GroupsDAO groupsDAO;
    private final PermissionsDAO permissionsDAO;
    private final MembershipsDAO membershipsDAO;
    private final InvitedRegistrationDAO invitedRegistrationDAO;
    private final LoggingDAO loggingDAO;

    @Autowired
    public GroupsService(GroupsDAO groupsDAO, PermissionsDAO permissionsDAO, MembershipsDAO membershipsDAO, InvitedRegistrationDAO invitedRegistrationDAO, LoggingDAO loggingDAO) {
        this.groupsDAO = groupsDAO;
        this.permissionsDAO = permissionsDAO;
        this.membershipsDAO = membershipsDAO;
        this.invitedRegistrationDAO = invitedRegistrationDAO;
        this.loggingDAO = loggingDAO;
        this.createRootIfNecessary();
    }

    private void createRootIfNecessary() {
        if (this.groupsDAO.count() == 0L) {
            GroupEntity root = new GroupEntity();
            root.setId(ROOT);
            root.setName(ROOT);
            root.setPath("");
            this.groupsDAO.createGroup(root);
        }
    }

    public GroupEntity addGroup(GroupEntity parent, String groupName, boolean leaf, String createdBy) {
        if (this.groupsDAO.getDirectSubGroups(parent.getPath()).stream().anyMatch(g -> g.getName().equals(groupName))) {
            throw new BadRequestException("There is already a group named " + groupName);
        }
        String newGroupId = UUID.randomUUID().toString().replaceAll("-", "");
        String path = parent.getPath();
        if (!path.isEmpty()) {
            path = path + ".";
        }
        path = path + newGroupId;
        GroupEntity group = new GroupEntity();
        group.setId(newGroupId);
        group.setName(groupName);
        group.setPath(path);
        group.setLeaf(leaf);
        group.setCreatedBy(createdBy);
        group.setCreationTime(new Date());
        this.groupsDAO.createGroup(group);
        this.loggingDAO.logAction(ActionType.GROUP_CREATED, "Added group: parent_path=" + parent.getPath() + ", group_name=" + groupName);
        return group;
    }

    public GroupEntity updateGroup(GroupEntity group, String newGroupName, boolean leaf) {
        if (this.groupsDAO.getDirectSubGroups(group.getPath()).stream().anyMatch(g -> g.getName().equals(newGroupName))) {
            throw new BadRequestException("There is already a group named " + newGroupName);
        }
        group.setName(newGroupName);
        group.setLeaf(leaf);
        GroupEntity entity = this.groupsDAO.updateGroup(group);
        this.loggingDAO.logAction(ActionType.GROUP_UPDATED, "Group updated, group_id=" + group.getId() + ", new name: " + newGroupName + ", leaf: " + leaf);
        return entity;
    }

    public GroupEntity deleteGroup(GroupEntity group) {
        if (ROOT.equals(group.getId())) {
            throw new UnauthorizedException("It is not possible to remove the ROOT");
        }
        if (group.isLocked()) {
            throw new UnauthorizedException("Group " + group.getId() + " is locked and can't be deleted");
        }
        String parentPath = group.getParentPath();
        GroupEntity parent = this.groupsDAO.findGroupByPath(parentPath).orElseThrow(() -> new BadRequestException("No group found at path " + parentPath));
        List<GroupEntity> groupsToDelete = this.groupsDAO.getAllChildren(group.getPath());
        groupsToDelete.add(group);
        List<String> groupsToDeleteIds = groupsToDelete.stream().map(g -> g.getId()).collect(Collectors.toList());
        this.invitedRegistrationDAO.deleteAllGroupsInvitedRegistrations(groupsToDeleteIds);
        this.membershipsDAO.deleteAllGroupsMembership(groupsToDeleteIds);
        this.permissionsDAO.deleteAllGroupsPermissions(groupsToDeleteIds);
        for (GroupEntity g2 : groupsToDelete) {
            this.groupsDAO.deleteGroup(g2);
        }
        this.loggingDAO.logAction(ActionType.GROUP_DELETED, "Group deleted [group_id=" + group.getId() + ", group_name=" + group.getName() + "]");
        return parent;
    }

    public GroupEntity getGroupById(String groupId) {
        return this.groupsDAO.findGroupById(groupId).orElseThrow(() -> new BadRequestException("Group " + groupId + " not found"));
    }

    public GroupEntity getGroupByPath(String path) {
        return this.groupsDAO.findGroupByPath(path).orElseThrow(() -> new BadRequestException("Group not found at path " + path));
    }

    public List<GroupBreadcrumb> getBreadcrumbs(String path) {
        return this.groupsDAO.getBreadcrumbs(path);
    }

    public Optional<GroupEntity> findGroupByParentAndName(GroupEntity parent, String childName) {
        return this.groupsDAO.findGroupByParentAndName(parent.getPath(), childName);
    }

    public Optional<GroupEntity> findGroupByNames(List<String> names) {
        String name;
        List<GroupEntity> groups = this.groupsDAO.findGroupsByNames(names);
        String parentPath = "";
        GroupEntity group = null;
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext() && (group = this.findGroup(groups, parentPath, name = iterator.next())) != null) {
            parentPath = group.getPath();
        }
        return Optional.ofNullable(group);
    }

    private GroupEntity findGroup(List<GroupEntity> groups, String parentPath, String groupName) {
        for (GroupEntity group : groups) {
            if (!parentPath.equals(group.getParentPath()) || !groupName.equals(group.getName())) continue;
            return group;
        }
        return null;
    }

    public List<GroupEntity> searchGroups(String searchText) {
        return this.groupsDAO.searchGroups(searchText);
    }

    public List<GroupEntity> getChildGroups(GroupEntity parentGroup, boolean recursive) {
        if (recursive) {
            return this.groupsDAO.getAllChildren(parentGroup.getPath());
        }
        return this.groupsDAO.getDirectSubGroups(parentGroup.getPath());
    }
}

