/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.persistence;

import it.inaf.ia2.gms.model.GroupBreadcrumb;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.service.hook.GroupsHook;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class GroupsDAO {
    private static final String GROUP_COLUMNS = "id, name, path, is_leaf, locked, creation_time, created_by";
    @Autowired(required=false)
    protected GroupsHook groupsHook;
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public GroupsDAO(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public GroupEntity createGroup(GroupEntity group) {
        if (this.groupsHook != null) {
            this.groupsHook.beforeCreate(group);
        }
        String sql = "INSERT INTO gms_group (id, name, path, is_leaf, locked, created_by) VALUES (?, ?, ?, ?, ?, ?)";
        this.jdbcTemplate.update(conn -> {
            int i = 0;
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(++i, group.getId());
            ps.setString(++i, group.getName());
            ps.setObject(++i, (Object)group.getPath(), 1111);
            ps.setBoolean(++i, group.isLeaf());
            ps.setBoolean(++i, group.isLocked());
            ps.setString(++i, group.getCreatedBy());
            return ps;
        });
        return group;
    }

    public GroupEntity updateGroup(GroupEntity group) {
        if (this.groupsHook != null) {
            this.groupsHook.beforeUpdate(group);
        }
        String sql = "UPDATE gms_group SET name = ?, path = ?, is_leaf = ?, locked = ? WHERE id = ?";
        this.jdbcTemplate.update(conn -> {
            int i = 0;
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(++i, group.getName());
            ps.setObject(++i, (Object)group.getPath(), 1111);
            ps.setBoolean(++i, group.isLeaf());
            ps.setBoolean(++i, group.isLocked());
            ps.setString(++i, group.getId());
            return ps;
        });
        return group;
    }

    public void deleteGroup(GroupEntity group) {
        if (this.groupsHook != null) {
            this.groupsHook.beforeDelete(group);
        }
        String sql = "DELETE FROM gms_group WHERE id = ?";
        this.jdbcTemplate.update(sql, new Object[]{group.getId()});
    }

    public Optional<GroupEntity> findGroupById(String groupId) {
        String sql = "SELECT id, name, path, is_leaf, locked, creation_time, created_by from gms_group WHERE id = ?";
        return (Optional)this.jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, groupId);
            return ps;
        }, resultSet -> {
            if (resultSet.next()) {
                GroupEntity group = this.getGroupFromResultSet(resultSet);
                return Optional.of(group);
            }
            return Optional.empty();
        });
    }

    public Optional<GroupEntity> findGroupByPath(String path) {
        String sql = "SELECT id, name, path, is_leaf, locked, creation_time, created_by from gms_group WHERE path = ?";
        return (Optional)this.jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setObject(1, (Object)path, 1111);
            return ps;
        }, resultSet -> {
            if (resultSet.next()) {
                GroupEntity group = this.getGroupFromResultSet(resultSet);
                return Optional.of(group);
            }
            return Optional.empty();
        });
    }

    public List<GroupEntity> findGroupsByIds(Set<String> identifiers) {
        if (identifiers.isEmpty()) {
            return new ArrayList<GroupEntity>();
        }
        return (List)this.jdbcTemplate.query(conn -> {
            String sql = "SELECT id, name, path, is_leaf, locked, creation_time, created_by from gms_group WHERE id IN (";
            sql = sql + String.join((CharSequence)",", identifiers.stream().map(p -> "?").collect(Collectors.toList()));
            sql = sql + ")";
            PreparedStatement ps = conn.prepareStatement(sql);
            int i = 0;
            for (String id : identifiers) {
                ps.setString(++i, id);
            }
            return ps;
        }, resultSet -> this.getGroupsFromResultSet(resultSet));
    }

    public Map<String, String> getGroupCompleteNamesFromId(Set<String> groupIds) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (groupIds.isEmpty()) {
            return result;
        }
        String sql = "SELECT id, complete_name FROM group_complete_name WHERE id IN (" + String.join((CharSequence)",", Collections.nCopies(groupIds.size(), "?")) + ")";
        this.jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            int i = 0;
            for (String groupId : groupIds) {
                ps.setString(++i, groupId);
            }
            return ps;
        }, (rs, index) -> {
            result.put(rs.getString("id"), rs.getString("complete_name"));
            return null;
        });
        return result;
    }

    public Optional<GroupEntity> findGroupByParentAndName(String parentPath, String childName) {
        String sql = "SELECT id, name, path, is_leaf, locked, creation_time, created_by from gms_group WHERE name = ? AND path ~ ?";
        return (Optional)this.jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, childName);
            ps.setObject(2, (Object)this.getSubGroupsPath(parentPath), 1111);
            return ps;
        }, resultSet -> {
            if (resultSet.next()) {
                GroupEntity group = this.getGroupFromResultSet(resultSet);
                return Optional.of(group);
            }
            return Optional.empty();
        });
    }

    public List<GroupEntity> getDirectSubGroups(String path) {
        return this.getDirectSubGroups(path, null);
    }

    public List<GroupEntity> getDirectSubGroups(String path, String searchFilter) {
        boolean hasSearchFilter = searchFilter != null && !searchFilter.trim().isEmpty();
        String sql = hasSearchFilter ? "SELECT id, name, path, is_leaf, locked, creation_time, created_by FROM gms_group WHERE path ~ ? AND name ILIKE ? ORDER BY name" : "SELECT id, name, path, is_leaf, locked, creation_time, created_by FROM gms_group WHERE path ~ ? ORDER BY name";
        return (List)this.jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setObject(1, (Object)this.getSubGroupsPath(path), 1111);
            if (hasSearchFilter) {
                ps.setObject(2, "%" + searchFilter + "%");
            }
            return ps;
        }, resultSet -> this.getGroupsFromResultSet(resultSet));
    }

    private String getSubGroupsPath(String path) {
        if (!path.isEmpty()) {
            path = path + ".";
        }
        path = path + "*{1}";
        return path;
    }

    public List<GroupEntity> getAllChildren(String path) {
        String sql = "SELECT id, name, path, is_leaf, locked, creation_time, created_by FROM gms_group WHERE path <@ ? AND path <> ? ORDER BY nlevel(path) DESC";
        return (List)this.jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setObject(1, (Object)path, 1111);
            ps.setObject(2, (Object)path, 1111);
            return ps;
        }, resultSet -> this.getGroupsFromResultSet(resultSet));
    }

    public List<GroupEntity> findGroupsByNames(List<String> names) {
        String sql = "SELECT id, name, path, is_leaf, locked, creation_time, created_by from gms_group WHERE name IN (" + String.join((CharSequence)",", names.stream().map(g -> "?").collect(Collectors.toList())) + ")";
        return (List)this.jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            int i = 0;
            for (String name : names) {
                ps.setString(++i, name);
            }
            return ps;
        }, resultSet -> this.getGroupsFromResultSet(resultSet));
    }

    private List<GroupEntity> getGroupsFromResultSet(ResultSet resultSet) throws SQLException {
        ArrayList<GroupEntity> groups = new ArrayList<GroupEntity>();
        while (resultSet.next()) {
            groups.add(this.getGroupFromResultSet(resultSet));
        }
        return groups;
    }

    private GroupEntity getGroupFromResultSet(ResultSet resultSet) throws SQLException {
        GroupEntity group = new GroupEntity();
        group.setId(resultSet.getString("id"));
        group.setName(resultSet.getString("name"));
        group.setPath(resultSet.getString("path"));
        group.setLeaf(resultSet.getBoolean("is_leaf"));
        group.setLocked(resultSet.getBoolean("locked"));
        group.setCreationTime(new Date(resultSet.getDate("creation_time").getTime()));
        group.setCreatedBy(resultSet.getString("created_by"));
        return group;
    }

    public Map<String, Boolean> getHasChildrenMap(Set<String> groupIds) {
        if (groupIds.isEmpty()) {
            return new HashMap<String, Boolean>();
        }
        String sql = "SELECT g.id, COUNT(s.*) > 0 AS has_children \nFROM gms_group g\nLEFT JOIN gms_group s ON s.path <@ g.path AND s.path <> g.path\nWHERE g.id IN(" + String.join((CharSequence)",", groupIds.stream().map(g -> "?").collect(Collectors.toList())) + ") GROUP BY g.id";
        return (Map)this.jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            int i = 0;
            for (String groupId : groupIds) {
                ps.setString(++i, groupId);
            }
            return ps;
        }, resultSet -> {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            while (resultSet.next()) {
                map.put(resultSet.getString("id"), resultSet.getBoolean("has_children"));
            }
            return map;
        });
    }

    public long count() {
        String sql = "SELECT COUNT(*) FROM gms_group";
        return (Long)this.jdbcTemplate.query(sql, resultSet -> {
            resultSet.next();
            return resultSet.getLong(1);
        });
    }

    public List<GroupBreadcrumb> getBreadcrumbs(String path) {
        String sql = "SELECT id, name FROM gms_group WHERE path @> ? ORDER BY length(path::varchar) ASC";
        return (List)this.jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setObject(1, (Object)path, 1111);
            return ps;
        }, resultSet -> {
            ArrayList<GroupBreadcrumb> breadcrumbs = new ArrayList<GroupBreadcrumb>();
            while (resultSet.next()) {
                GroupBreadcrumb bc = new GroupBreadcrumb();
                bc.setGroupId(resultSet.getString("id"));
                bc.setGroupName(resultSet.getString("name"));
                breadcrumbs.add(bc);
            }
            return breadcrumbs;
        });
    }

    public List<GroupEntity> searchGroups(String searchText) {
        String sql = "SELECT id, name, path, is_leaf, locked, creation_time, created_by from gms_group WHERE name ILIKE ?";
        return (List)this.jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, "%" + searchText + "%");
            return ps;
        }, resultSet -> this.getGroupsFromResultSet(resultSet));
    }
}

