/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.manager.GroupsManager;
import it.inaf.ia2.gms.manager.InvitedRegistrationManager;
import it.inaf.ia2.gms.manager.PermissionsManager;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.request.GroupsRequest;
import it.inaf.ia2.gms.model.response.GroupsTabResponse;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.service.GroupsService;
import it.inaf.ia2.gms.service.GroupsTreeBuilder;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupsTabResponseBuilder {
    @Autowired
    HttpServletRequest servletRequest;
    @Autowired
    private PermissionsManager permissionsManager;
    @Autowired
    private GroupsManager groupsManager;
    @Autowired
    private GroupsService groupsService;
    @Autowired
    private GroupsTreeBuilder groupsListBuilder;
    @Autowired
    private InvitedRegistrationManager invitedRegistrationManager;

    public GroupsTabResponse getGroupsTab(GroupsRequest request) {
        GroupEntity group = this.groupsService.getGroupById(request.getGroupId());
        this.groupsManager.verifyUserCanReadGroup(group);
        GroupsTabResponse response = new GroupsTabResponse();
        response.setBreadcrumbs(this.groupsService.getBreadcrumbs(group.getPath()));
        Permission permission = this.permissionsManager.getCurrentUserPermission(group);
        response.setPermission(permission);
        response.setGroupsPanel(this.groupsListBuilder.listSubGroups(group, request, this.servletRequest.getUserPrincipal().getName()));
        response.setLeaf(group.isLeaf());
        response.setInvitedRegistrations(this.invitedRegistrationManager.getInvitedRegistrationsForGroup(group));
        return response;
    }
}

