/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.client.BaseClient;
import it.inaf.ia2.gms.client.GmsClient;
import java.io.InputStream;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class ListGroupsCall
extends BaseCall<GmsClient> {
    public ListGroupsCall(GmsClient client) {
        super((BaseClient)client);
    }

    public List<String> listGroups(String parentGroup, boolean recursive) {
        ArrayList groups = new ArrayList();
        if (parentGroup == null) {
            parentGroup = "";
        }
        String uri = "groups?parent=" + URLEncoder.encode(parentGroup, StandardCharsets.UTF_8) + "&recursive=" + recursive;
        HttpRequest groupsRequest = ((GmsClient)this.client).newRequest(uri).header("Accept", "text/plain").GET().build();
        return (List)((GmsClient)this.client).call(groupsRequest, HttpResponse.BodyHandlers.ofInputStream(), 200, inputStream -> {
            try (Scanner scan = new Scanner((InputStream)inputStream);){
                while (scan.hasNextLine()) {
                    String line = scan.nextLine();
                    if (line.isEmpty()) continue;
                    groups.add(line);
                }
            }
            return groups;
        });
    }
}

