/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.client.BaseClient;
import it.inaf.ia2.gms.client.GmsClient;
import it.inaf.ia2.gms.client.model.Permission;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import java.util.stream.Collectors;

public class AddInvitedRegistrationCall
extends BaseCall<GmsClient> {
    public AddInvitedRegistrationCall(GmsClient client) {
        super((BaseClient)client);
    }

    public void addInvitedRegistration(String token, String email, Map<String, Permission> groupsPermissions) {
        String tokenHash = this.getTokenHash(token);
        String endpoint = "invited-registration";
        String bodyParams = "token_hash=" + tokenHash.replace("+", "%2B") + "&email=" + email + "&groups=" + String.join((CharSequence)"\n", groupsPermissions.entrySet().stream().map(e -> (String)e.getKey() + " " + e.getValue()).collect(Collectors.toList()));
        HttpRequest groupsRequest = ((GmsClient)this.client).newRequest(endpoint).header("Accept", "text/plain").header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(bodyParams)).build();
        ((GmsClient)this.client).call(groupsRequest, HttpResponse.BodyHandlers.ofInputStream(), 201, res -> true);
    }

    private String getTokenHash(String token) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(token.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }
}

