/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.client.BaseClient;
import it.inaf.ia2.gms.client.GmsClient;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class GetUserGroupsCall
extends BaseCall<GmsClient> {
    public GetUserGroupsCall(GmsClient client) {
        super((BaseClient)client);
    }

    public List<String> getUserGroups(String prefix) {
        ArrayList groups = new ArrayList();
        HttpRequest groupsRequest = ((GmsClient)this.client).newRequest("search").header("Accept", "text/plain").GET().build();
        return (List)((GmsClient)this.client).call(groupsRequest, HttpResponse.BodyHandlers.ofInputStream(), 200, inputStream -> {
            try (Scanner scan = new Scanner((InputStream)inputStream);){
                while (scan.hasNextLine()) {
                    String line = scan.nextLine();
                    if (line.isEmpty()) continue;
                    if (prefix == null || prefix.isEmpty()) {
                        groups.add(line);
                        continue;
                    }
                    if (!line.startsWith(prefix)) continue;
                    line = line.substring(prefix.length());
                    groups.add(line);
                }
            }
            return groups;
        });
    }

    public List<String> getUserGroups(String userId, String prefix) {
        ArrayList groups = new ArrayList();
        Object endpoint = "membership";
        if (prefix != null && !prefix.isBlank()) {
            endpoint = (String)endpoint + "/" + prefix;
        }
        endpoint = (String)endpoint + "?user_id=" + userId;
        HttpRequest groupsRequest = ((GmsClient)this.client).newRequest((String)endpoint).header("Accept", "text/plain").GET().build();
        return (List)((GmsClient)this.client).call(groupsRequest, HttpResponse.BodyHandlers.ofInputStream(), 200, inputStream -> {
            try (Scanner scan = new Scanner((InputStream)inputStream);){
                while (scan.hasNextLine()) {
                    String line = scan.nextLine();
                    if (line.isEmpty()) continue;
                    groups.add(line);
                }
            }
            return groups;
        });
    }
}

