/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.userspace.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class FileInfo {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private String fileName;
    private long size;
    private String creationDate;

    protected FileInfo() {
    }

    private SimpleDateFormat getSimpleDateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    public FileInfo(File file) {
        this.fileName = file.getName();
        this.size = file.length();
        this.creationDate = this.getSimpleDateFormat().format(file.lastModified());
    }

    @JsonProperty(value="name")
    public String getFileName() {
        return this.fileName;
    }

    protected void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @JsonProperty(value="created")
    public String getCreationDateStr() {
        return this.creationDate;
    }

    protected void setCreationDateStr(String creationDate) {
        this.creationDate = creationDate;
    }

    @JsonIgnore
    public Date getCreationDate() throws ParseException {
        return this.getSimpleDateFormat().parse(this.creationDate);
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }
}

