/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.tng;

import it.inaf.ia2.query.builder.DefaultQueryBuilder;
import it.inaf.ia2.query.util.RADecConverter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class TNGQueryBuilder
extends DefaultQueryBuilder {
    private static final List<String> AAO_KEYWORDS_TO_IGNORE = TNGQueryBuilder.createKeywordsToIgnoreList((String[])new String[]{"ra_sel", "dec_sel", "DATE_OBS", "DATE_OBS_min", "DATE_OBS_max", "NIGHT_DATE", "NIGHT_DATE_min", "NIGHT_DATE_max", "include_solar"});
    private final Set<String> mainGridColumns = new HashSet<String>(Arrays.asList("EXP_ID", "DATE_OBS", "OBS_MODE", "INSTRUMENT", "PROGRAM", "OBJECT", "EXPTIME", "NIGHT_DATE", "AIRMASS"));

    public TNGQueryBuilder(Map<String, Object> params) {
        super(params);
    }

    private String formatDate(Object date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.s");
        return sdf.format(date);
    }

    protected void appendWhere() {
        this.addLikeCondition("tng.EXP_ID", "EXP_ID", true, true);
        this.addLikeCondition("tng.INSTRUMENT", "INSTRUMENT", false, false);
        this.addLikeCondition("tng.OBS_MODE", "OBS_MODE", false, false);
        this.addLikeCondition("tng.PROGRAM", "PROGRAM", false, true);
        this.addDateCondition();
        this.addNightDateCondition();
        this.appendPositionalSearch();
        this.appendGroupsCondition();
        this.appendSolarCondition();
        super.appendWhere();
    }

    private void addDateCondition() {
        this.addCondition("tng.DATE_OBS", ">=", "DATE_OBS_min", this::formatDate);
        this.addCondition("tng.DATE_OBS", "<=", "DATE_OBS_max", this::formatDate);
    }

    private void addNightDateCondition() {
        this.addCondition("tng.NIGHT_DATE", ">=", "NIGHT_DATE_min", this::formatDate);
        this.addCondition("tng.NIGHT_DATE", "<=", "NIGHT_DATE_max", this::formatDate);
    }

    private void appendPositionalSearch() {
        if (this.has("ra") && this.has("dec") && this.has("radius")) {
            double ra = RADecConverter.getRARadians((String)((String)this.get("ra", String.class)));
            double dec = RADecConverter.getDecRadians((String)((String)this.get("dec", String.class)));
            double radius = RADecConverter.getRadiusRadians((double)this.getDouble("radius"));
            this.addToWhere(String.format("(\"%s\".\"%s\" BETWEEN %s AND %s) AND (\"%s\".\"%s\" BETWEEN %s AND %s)", "tng", "RA_RAD", ra - radius, ra + radius, "tng", "DEC_RAD", dec - radius, dec + radius));
        }
    }

    private void appendGroupsCondition() {
        List groups;
        if (this.has("user_groups") && !this.has("PROGRAM") && !(groups = (List)this.get("user_groups", List.class)).isEmpty()) {
            this.addToWhere("tng.PROGRAM IN(" + this.getSafeParamList(groups) + ")");
        }
    }

    private void appendSolarCondition() {
        if (!this.getBool("include_solar")) {
            this.addToWhere("tng.PROGRAM <> 'SOLAR'");
        }
    }

    protected String getFullColumnName(String columnKey) {
        if (this.mainGridColumns.contains(columnKey)) {
            return "tng." + columnKey;
        }
        String tab = (String)this.get("secondary_tab", String.class);
        if (tab == null) {
            throw new IllegalStateException("Unable to find a table for the column " + columnKey);
        }
        return tab + "." + columnKey;
    }

    protected List<String> getKeywordsToIgnore() {
        return AAO_KEYWORDS_TO_IGNORE;
    }

    public void appendJoins() {
        if (this.has("secondary_tab")) {
            switch ((String)this.get("secondary_tab", String.class)) {
                case "gianob": {
                    this.append("JOIN tng.gianob gianob ON tng.EXP_ID = gianob.EXP_ID");
                    break;
                }
                case "giano": {
                    this.append("JOIN tng.giano giano ON tng.EXP_ID = giano.EXP_ID");
                    break;
                }
                case "harpn": {
                    this.append("JOIN tng.harpn harpn ON tng.EXP_ID = harpn.EXP_ID");
                    break;
                }
                case "sarg": {
                    this.append("JOIN tng.sarg sarg ON tng.EXP_ID = sarg.EXP_ID");
                    break;
                }
                case "oig": {
                    this.append("JOIN tng.oig oig ON tng.EXP_ID = oig.EXP_ID");
                    break;
                }
                case "nics": {
                    this.append("JOIN tng.nics nics ON tng.EXP_ID = nics.EXP_ID");
                    break;
                }
                case "lrs": {
                    this.append("JOIN tng.lrs lrs ON tng.EXP_ID = lrs.EXP_ID");
                }
            }
        }
    }
}

