/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.svas;

import it.inaf.ia2.query.builder.DefaultQueryBuilder;
import it.inaf.ia2.query.util.RADecConverter;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;

public abstract class SVASQueryBuilder
extends DefaultQueryBuilder {
    private static final List<String> SVAS_KEYWORDS_TO_IGNORE = SVASQueryBuilder.createKeywordsToIgnoreList((String[])new String[]{"ra_sel", "dec_sel", "DATE_OBS_min", "DATE_OBS_max"});

    public SVASQueryBuilder(Map<String, Object> params) {
        super(params);
    }

    protected List<String> getKeywordsToIgnore() {
        return SVAS_KEYWORDS_TO_IGNORE;
    }

    protected void appendWhere() {
        this.appendPositionalSearch();
        this.addCondition("DATE_OBS", ">=", "DATE_OBS_min", this::formatDate);
        this.addCondition("DATE_OBS", "<=", "DATE_OBS_max", this::formatDate);
        this.addLikeCondition("FILTER", false, true);
        this.addLikeCondition("INSTRUMENT", false, true);
        this.addLikeCondition("IMAGETYP", false, true);
        this.appendGroupsCondition();
        super.appendWhere();
    }

    private String formatDate(Object date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    private void appendPositionalSearch() {
        if (this.has("ra") && this.has("dec") && this.has("radius")) {
            double ra = RADecConverter.getRADegrees((String)((String)this.get("ra", String.class)));
            double dec = RADecConverter.getDecDegrees((String)((String)this.get("dec", String.class)));
            double radius = this.getDouble("radius") / 60.0;
            this.addToWhere("s_point IS NOT NULL AND 1=CONTAINS(s_point, CIRCLE('ICRS'," + ra + "," + dec + "," + radius + "))");
        }
    }

    private void appendGroupsCondition() {
        List groups;
        if (this.has("user_groups") && !this.has("program") && !(groups = (List)this.get("user_groups", List.class)).isEmpty()) {
            this.addToWhere("PROJECT IN(" + this.getSafeParamList(groups) + ")");
        }
    }
}

