/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.radio;

import it.inaf.ia2.query.radio.FrequencySupportData;
import it.inaf.ia2.query.result.CompositeQueryResult;
import it.inaf.ia2.query.result.QueryResultBuilderComposite;
import it.inaf.ia2.query.result.QueryResultBuilderParams;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class RadioQueryResultBuilder
extends QueryResultBuilderComposite {
    private static final List<String> FREQUENCY_SETUP_COLUMNS = List.of("min_freq", "max_freq", "bandwid", "freq_bin", "freqres", "restfreq", "polatype");
    private static final List<String> FREQUENCY_SETUP_COLUMNS_LABELS = new ArrayList<String>();

    public RadioQueryResultBuilder(QueryResultBuilderParams params, Set<String> rowspanColumns, String compositeRowIndexName) {
        super(params, rowspanColumns, compositeRowIndexName);
    }

    public CompositeQueryResult buildResult() {
        CompositeQueryResult result = super.buildResult();
        if (!this.params.getQueryList().contains("telescop <> 'VLBIT'")) {
            return result;
        }
        List originalCompositeRows = result.getRows();
        ArrayList<ArrayList<Object>> modifiedCompositeRows = new ArrayList<ArrayList<Object>>();
        ArrayList<String> frequencyColumns = new ArrayList<String>();
        ArrayList<String> frequencyColumnLabels = new ArrayList<String>();
        for (Object column : result.getColumns()) {
            if (!FREQUENCY_SETUP_COLUMNS.contains(column)) continue;
            frequencyColumns.add((String)column);
            int columnIndex = FREQUENCY_SETUP_COLUMNS.indexOf(column);
            frequencyColumnLabels.add(FREQUENCY_SETUP_COLUMNS_LABELS.get(columnIndex));
        }
        Integer frequencySupportIndex = null;
        for (List originalCompositeRow : originalCompositeRows) {
            ArrayList<Object> modifiedCompositeRow = new ArrayList<Object>();
            ArrayList<Object> firstRowOfComposite = null;
            for (Object originalSubRowObject : originalCompositeRow) {
                FrequencySupportData compositeFrequencyRow;
                List originalSubRow = (List)originalSubRowObject;
                ArrayList<Object> newModifiedSubrow = new ArrayList<Object>();
                ArrayList<Object> frequencyRow = new ArrayList<Object>();
                for (int i = 0; i < originalSubRow.size(); ++i) {
                    Object originalCell = originalSubRow.get(i);
                    String column = (String)result.getColumns().get(i);
                    if (FREQUENCY_SETUP_COLUMNS.contains(column)) {
                        if (frequencySupportIndex == null) {
                            frequencySupportIndex = i;
                        }
                        frequencyRow.add(originalCell);
                        continue;
                    }
                    newModifiedSubrow.add(originalCell);
                }
                boolean duplicatedRow = this.isDuplicatedRow(result, frequencySupportIndex, modifiedCompositeRow, newModifiedSubrow);
                if (!duplicatedRow) {
                    modifiedCompositeRow.add(newModifiedSubrow);
                }
                if (frequencySupportIndex == null || frequencyRow.isEmpty()) continue;
                if (firstRowOfComposite == null) {
                    firstRowOfComposite = newModifiedSubrow;
                    compositeFrequencyRow = new FrequencySupportData();
                    compositeFrequencyRow.setColumns(frequencyColumns);
                    compositeFrequencyRow.setColumnsLabels(frequencyColumnLabels);
                    newModifiedSubrow.add(frequencySupportIndex, compositeFrequencyRow);
                } else {
                    newModifiedSubrow.add(frequencySupportIndex, null);
                    compositeFrequencyRow = (FrequencySupportData)firstRowOfComposite.get(frequencySupportIndex);
                }
                compositeFrequencyRow.addRow(frequencyRow);
            }
            modifiedCompositeRows.add(modifiedCompositeRow);
        }
        result.getRows().clear();
        result.getRows().addAll(modifiedCompositeRows);
        ArrayList<String> newColumns = new ArrayList<String>();
        for (int i = 0; i < result.getColumns().size(); ++i) {
            String column = (String)result.getColumns().get(i);
            if (!FREQUENCY_SETUP_COLUMNS.contains(column)) {
                newColumns.add(column);
                continue;
            }
            if (frequencySupportIndex == null || frequencySupportIndex != i) continue;
            newColumns.add("frequency_setup");
        }
        result.setColumns(newColumns);
        return result;
    }

    private boolean isDuplicatedRow(CompositeQueryResult result, Integer frequencySupportIndex, List<Object> modifiedCompositeRow, List<Object> newModifiedSubrow) {
        if (frequencySupportIndex == null) {
            return false;
        }
        boolean duplicatedRow = false;
        block0: for (Object modifiedSubRowObject : modifiedCompositeRow) {
            List modifiedSubrow = (List)modifiedSubRowObject;
            int j = 0;
            int k = 0;
            for (int i = 0; i < result.getColumns().size(); ++i) {
                String column = (String)result.getColumns().get(i);
                if (k == frequencySupportIndex) {
                    ++k;
                } else if (!FREQUENCY_SETUP_COLUMNS.contains(column)) {
                    Object cell = modifiedSubrow.get(k);
                    Object newCell = newModifiedSubrow.get(j);
                    if (!String.valueOf(cell).equals(String.valueOf(newCell))) continue block0;
                    ++j;
                    ++k;
                }
                if (i != result.getColumns().size() - 1) continue;
                duplicatedRow = true;
            }
        }
        return duplicatedRow;
    }

    static {
        try (InputStream in = RadioQueryResultBuilder.class.getClassLoader().getResourceAsStream("columns.properties");){
            Properties props = new Properties();
            props.load(in);
            for (String columnKey : FREQUENCY_SETUP_COLUMNS) {
                FREQUENCY_SETUP_COLUMNS_LABELS.add((String)props.getOrDefault((Object)columnKey, columnKey));
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

