/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.radio;

import it.inaf.ia2.query.SortInfo;
import it.inaf.ia2.query.builder.ListQueryBuilder;
import it.inaf.ia2.query.builder.QueryBuilder;
import it.inaf.ia2.query.radio.RadioQueryBuilder;
import it.inaf.ia2.query.radio.Tab;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RadioListQueryBuilder
extends RadioQueryBuilder
implements ListQueryBuilder {
    public RadioListQueryBuilder(Map<String, Object> params) {
        super(params);
    }

    public QueryBuilder buildQuery() {
        this.append("SELECT");
        switch (this.getTab()) {
            case PULSAR: {
                this.appendTopAndOffset();
                this.appendSelectList();
                this.append("FROM pulsar.pulsar");
                this.appendWhere();
                break;
            }
            default: {
                this.appendSelectList();
                this.append("FROM (");
                this.appendInnerQuery();
                this.append(") AS fi_inner");
                if (this.getTab() == Tab.SIMPLE) {
                    this.append("JOIN \"all\".radio a ON fi_inner.file_name = a.file_name");
                } else {
                    this.append("JOIN radio.file_info fi ON fi_inner.file_name = fi.file_name");
                }
                this.appendJoins();
            }
        }
        this.appendSort();
        return this;
    }

    private void appendInnerQuery() {
        this.append("SELECT DISTINCT");
        this.appendTopAndOffset();
        ArrayList<String> columns = new ArrayList<String>();
        if (this.getTab() == Tab.SIMPLE) {
            columns.add("file_name");
        } else {
            columns.add("fi.file_name AS file_name");
        }
        List sortInfos = null;
        if (this.has("sort") && (sortInfos = (List)this.get("sort", List.class)) != null && !sortInfos.isEmpty()) {
            sortInfos.forEach(s -> {
                if (!"file_name".equals(s.getColumnName())) {
                    columns.add(this.getSortColumnSelection((SortInfo)s));
                }
            });
        }
        this.appendList(columns, ", ");
        if (this.getTab() == Tab.SIMPLE) {
            this.append("FROM \"all\".radio a");
        } else {
            this.append("FROM radio.file_info fi");
            this.appendJoins();
        }
        this.appendWhere();
        this.append("ORDER BY");
        if (sortInfos != null && !sortInfos.isEmpty()) {
            this.appendList(sortInfos.stream().map(sortInfo -> {
                String columnName = sortInfo.getColumnName();
                if ("frequency_setup".equals(columnName)) {
                    columnName = "min_freq";
                }
                return String.format("%s %s", columnName, sortInfo.getSort());
            }).collect(Collectors.toList()), ", ");
        } else {
            this.append("file_name ASC");
        }
    }

    private String getSortColumnSelection(SortInfo sortInfo) {
        switch (sortInfo.getColumnName()) {
            case "policy": {
                if (this.getTab() == Tab.SIMPLE) break;
                return "fi.policy AS policy";
            }
            case "program": {
                if (this.getTab() == Tab.SIMPLE) break;
                return "df.projid AS program";
            }
            case "schedule_name": {
                return "s.file_name AS schedule_name";
            }
            case "frequency_setup": {
                return "ad.min_freq";
            }
        }
        return sortInfo.getColumnName();
    }

    protected void appendSelectList() {
        if (this.getTab() == Tab.PULSAR) {
            this.addToSelect("file_name");
            this.addToSelect("url", "file_url");
            this.addToSelect("policy", "policy");
            this.addToSelect("projid", "program");
            if (this.getBool("ra_sel")) {
                this.addToSelect("RA_C", "ra_char");
            }
            if (this.getBool("dec_sel")) {
                this.addToSelect("DEC_C", "dec_char");
            }
            if (this.getBool("freq_sel")) {
                this.addToSelect("obsfreq", "freq");
            }
            this.conditionalAddToSelect("telescope");
            this.conditionalAddToSelect("obs_mode");
            this.conditionalAddToSelect("backend");
            this.conditionalAddToSelect("observer");
            this.conditionalAddToSelect("date_obs");
            this.conditionalAddToSelect("nbits");
            this.conditionalAddToSelect("npol");
            this.conditionalAddToSelect("tbin");
            this.conditionalAddToSelect("chan_bw");
        } else {
            if (this.getTab() == Tab.SIMPLE) {
                this.addToSelect("a.file_name", "file_name");
                this.addToSelect("a.file_url", "file_url");
                this.addToSelect("a.type", "type");
                this.addToSelect("a.policy", "policy");
                this.addToSelect("a.program", "program");
                if (this.getBool("ra_sel")) {
                    this.addToSelect("a.ra_char", "ra_char");
                }
                if (this.getBool("dec_sel")) {
                    this.addToSelect("a.dec_char", "dec_char");
                }
                this.conditionalAddToSelect("a.date_obs", "date_obs");
                if (this.getBool("freq_sel")) {
                    this.addToSelect("a.min_freq", "min_freq");
                    this.addToSelect("a.max_freq", "max_freq");
                }
            } else {
                this.addToSelect("fi.file_name", "file_name");
                this.addToSelect("fi.file_url", "file_url");
                this.addToSelect("fi.policy", "policy");
                this.addToSelect("df.projid", "program");
                if (this.getBool("ra_sel")) {
                    this.addToSelect("df.ra_char", "ra_char");
                }
                if (this.getBool("dec_sel")) {
                    this.addToSelect("df.dec_char", "dec_char");
                }
                this.conditionalAddToSelect("df.dateobs", "dateobs");
                if (this.getBool("freq_sel")) {
                    this.addToSelect("ad.min_freq", "min_freq");
                    this.addToSelect("ad.max_freq", "max_freq");
                }
            }
            switch (this.getTab()) {
                case VLBI: {
                    this.appendVLBISelectList();
                    break;
                }
                case SD: {
                    this.appendSDSelectList();
                }
            }
        }
        super.appendSelectList();
    }

    private void appendVLBISelectList() {
        this.addToSelect("df.object", "object");
        this.conditionalAddToSelect("df.piname", "piname");
        this.conditionalAddToSelect("df.telescop", "telescop");
        this.conditionalAddToSelect("df.exptime", "exptime");
        this.conditionalAddToSelect("df.antennas", "antennas");
        this.conditionalAddToSelect("df.rate", "rate");
        this.conditionalAddToSelect("df.channels_vlbi", "channels");
        this.conditionalAddToSelect("df.ch_resol", "ch_resol");
        this.conditionalAddToSelect("df.ontime", "ontime");
        this.conditionalAddToSelect("ad.bandwid", "bandwid");
    }

    private void appendSDSelectList() {
        this.addToSelect("df.object", "object");
        this.conditionalAddToSelect("df.telescop", "telescop");
        this.conditionalAddToSelect("fe.frontend", "frontend");
        this.conditionalAddToSelect("fe.backend", "backend");
        this.conditionalAddToSelect("ad.bandwid", "bandwid");
        this.conditionalAddToSelect("df.equinox", "equinox");
        this.conditionalAddToSelect("df.exptime", "exptime");
        this.conditionalAddToSelect("df.lst", "lst");
        this.conditionalAddToSelect("df.scantype", "scantype");
        this.conditionalAddToSelect("df.scanmode", "scanmode");
        this.conditionalAddToSelect("df.scangeom", "scangeom");
        this.conditionalAddToSelect("ss.usrframe", "usrframe");
        this.conditionalAddToSelect("df.scanxvel", "scanxvel");
        this.conditionalAddToSelect("fe.swtchmod", "swtchmod");
        this.conditionalAddToSelect("ad.freqres", "freqres");
        this.conditionalAddToSelect("ad.restfreq", "restfreq");
        this.conditionalAddToSelect("ad.freq_bin", "freq_bin");
        if (this.hasFrequencySupportPopUp()) {
            this.addToSelect("ad.polatype", "polatype");
        }
        this.conditionalAddToSelect("df.wobused", "wobused");
        this.conditionalAddToSelect("df.obsid", "obsid");
        this.conditionalAddToSelect("df.creator", "creator");
        this.conditionalAddToSelect("df.fitsver", "fitsver");
        this.addToSelect("s.file_name", "schedule_name");
        this.addToSelect("s.file_url", "schedule_url");
    }

    private boolean hasFrequencySupportPopUp() {
        return this.getBool("freq_sel") || this.getBool("bandwid_sel") || this.getBool("freq_bin_sel") || this.getBool("freqres_sel") || this.getBool("restfreq_sel");
    }

    protected void appendSort() {
        if (this.getTab() == Tab.PULSAR) {
            List sortInfos;
            if (this.has("sort") && (sortInfos = (List)this.get("sort", List.class)) != null && !sortInfos.isEmpty()) {
                List sorts = sortInfos.stream().map(sortInfo -> {
                    String columnName = sortInfo.getColumnName();
                    if ("frequency_setup".equals(columnName)) {
                        columnName = "min_freq";
                    }
                    return String.format("%s %s", columnName, sortInfo.getSort());
                }).collect(Collectors.toList());
                this.append("ORDER BY");
                this.appendList(sorts, ", ");
            }
        } else {
            List sortInfos;
            this.append("ORDER BY file_name");
            String fileNameSort = "ASC";
            if (this.has("sort") && (sortInfos = (List)this.get("sort", List.class)) != null) {
                fileNameSort = sortInfos.stream().filter(s -> "file_name".equals(s.getColumnName())).findFirst().map(s -> s.getSort()).orElse("ASC");
            }
            this.append(fileNameSort);
        }
    }
}

