/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.radio;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public class FrequencySupportData {
    private final List<List<Object>> rows = new ArrayList<List<Object>>();
    private List<String> columnsLabels;
    private List<String> columns;

    public List<List<Object>> getRows() {
        return this.rows;
    }

    public void addRow(List<Object> row) {
        this.rows.add(row);
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public List<String> getColumnsLabels() {
        return this.columnsLabels;
    }

    public void setColumnsLabels(List<String> columnsLabels) {
        this.columnsLabels = columnsLabels;
    }

    public String toString() {
        StringBuilder html = new StringBuilder();
        html.append("<span class=\"frequency-support-cell\">");
        html.append("<a href=\"#\" onclick=\"toggleFrequencySupport(event)\">");
        html.append(this.getCellText());
        html.append("</a>");
        html.append("<div class=\"frequency-support-popover\"><table>");
        html.append("<thead><tr>");
        for (String string : this.columnsLabels) {
            html.append("<th>");
            html.append(string);
            html.append("</th>");
        }
        html.append("</tr></thead>");
        html.append("<tbody>");
        for (List list : this.rows) {
            html.append("<tr>");
            for (Object cell : list) {
                html.append("<td>");
                html.append(cell);
                html.append("</td>");
            }
            html.append("</tr>");
        }
        html.append("</tbody>");
        html.append("</table>");
        html.append("</div>");
        html.append("</span>");
        return html.toString();
    }

    private String getCellText() {
        if (this.columns.contains("min_freq") && this.columns.contains("max_freq")) {
            String minFreq = this.getMinFreq();
            String maxFreq = this.getMaxFreq();
            if (minFreq != null && maxFreq != null) {
                return minFreq + ".." + maxFreq + " MHz";
            }
        }
        return "Expand";
    }

    private String getMinFreq() {
        return this.getFreqValue("min_freq", (freq, foundFreq) -> freq < foundFreq);
    }

    private String getMaxFreq() {
        return this.getFreqValue("max_freq", (freq, foundFreq) -> freq > foundFreq);
    }

    private String getFreqValue(String key, BiFunction<Double, Double, Boolean> comparator) {
        int freqIndex = this.columns.indexOf(key);
        Double foundFreq = null;
        String foundFreqString = null;
        for (List<Object> row : this.rows) {
            String freqString;
            if (row.get(freqIndex) == null || (freqString = String.valueOf(row.get(freqIndex))).isBlank()) continue;
            try {
                double freq = Double.parseDouble(freqString);
                if (foundFreq != null && !comparator.apply(freq, foundFreq).booleanValue()) continue;
                foundFreq = freq;
                foundFreqString = freqString;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return foundFreqString;
    }
}

