/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.query.radio;

import it.inaf.ia2.query.builder.BaseQueryBuilder;
import it.inaf.ia2.query.radio.Tab;
import it.inaf.ia2.query.util.RADecConverter;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class RadioQueryBuilder
extends BaseQueryBuilder {
    private boolean joinArraydata;
    private boolean joinBaseband;
    private boolean joinFebe;
    private boolean joinSubscan;

    public RadioQueryBuilder(Map<String, Object> params) {
        super(params);
        this.checkTablesToJoin();
    }

    private void checkTablesToJoin() {
        this.joinArraydata = this.hasToJoinArraydata();
        this.joinBaseband = this.hasToJoinBaseband();
        this.joinFebe = this.hasToJoinFebe();
        this.joinSubscan = this.hasToJoinSubscan();
    }

    private boolean hasToJoinArraydata() {
        return this.checkSimpleFields("channels", "freqres", "restfreq", "bandwid") || this.getBool("freq_sel") || this.has("min_freq_min") || this.has("max_freq_max");
    }

    private boolean hasToJoinBaseband() {
        return this.checkSimpleFields("baseband", "freq_bin");
    }

    private boolean hasToJoinFebe() {
        if (this.joinBaseband) {
            return true;
        }
        return this.checkSimpleFields("frontend", "backend", "swtchmod");
    }

    private boolean hasToJoinSubscan() {
        return this.checkSimpleFields("usrframe");
    }

    private boolean checkSimpleFields(String ... keys) {
        for (String key : keys) {
            if (!this.getBool(key + "_sel") && !this.has(key)) continue;
            return true;
        }
        return false;
    }

    protected Tab getTab() {
        String tab;
        switch (tab = (String)this.get("tab", String.class)) {
            case "simple": {
                return Tab.SIMPLE;
            }
            case "vlbi": {
                return Tab.VLBI;
            }
            case "sd": {
                return Tab.SD;
            }
            case "pulsar": {
                return Tab.PULSAR;
            }
        }
        throw new UnsupportedOperationException("Invalid tab: " + tab);
    }

    protected void appendJoins() {
        Tab tab = this.getTab();
        if (tab == Tab.PULSAR || tab == Tab.SIMPLE) {
            return;
        }
        this.append("LEFT JOIN radio.data_file df ON fi.file_info_id = df.file_info_id");
        if (tab == Tab.SD) {
            this.append("LEFT JOIN radio.schedule s ON df.schedulename || '.tar' = s.file_name");
        }
        if (this.joinArraydata) {
            this.append("LEFT JOIN radio.arraydata ad ON df.data_file_id = ad.data_file_id");
        }
        if (this.joinFebe) {
            this.append("LEFT JOIN radio.febe fe ON fe.data_file_id = df.data_file_id");
        }
        if (this.joinBaseband) {
            this.append("LEFT JOIN radio.baseband bb ON bb.febe_id = fe.febe_id");
        }
        if (this.joinSubscan) {
            this.append("LEFT JOIN radio.subscan ss ON ss.data_file_id = df.data_file_id");
        }
    }

    protected void appendWhere() {
        block0 : switch (this.getTab()) {
            case PULSAR: {
                this.addLikeCondition("file_name", false, true);
                this.addCondition("obs_mode", "=");
                this.addCondition("telescope", "=");
                this.addLikeCondition("projid", "program", false, true);
                this.addPulsarBackendCondition();
                this.addLikeCondition("observer", true, true);
                this.addRangeCondition("date_obs", this::formatDate);
                break;
            }
            case SIMPLE: {
                this.addLikeCondition("file_name", false, true);
                this.addRangeCondition("date_obs", this::formatDate);
                this.addProgramCondition();
                this.addLikeCondition("projid", false, true);
                this.addCondition("min_freq", ">=", "min_freq_min");
                this.addCondition("max_freq", "<=", "max_freq_max");
                break;
            }
            default: {
                this.addLikeCondition("fi.file_name", "file_name", false, true);
                this.addRangeCondition("df.dateobs", "dateobs", this::formatDate);
                this.addFrequencyCondition();
                this.addProgramCondition();
                this.addLikeCondition("df.projid", "program", false, true);
                switch (this.getTab()) {
                    case VLBI: {
                        this.appendVLBIWhere();
                        break block0;
                    }
                    case SD: {
                        this.appendSDWhere();
                    }
                }
            }
        }
        this.addPositionalSearch();
        super.appendWhere();
    }

    private void addPositionalSearch() {
        if (this.has("ra") && this.has("dec") && this.has("radius")) {
            String raChar = (String)this.get("ra", String.class);
            String decChar = (String)this.get("dec", String.class);
            double radius = this.getDouble("radius");
            if (radius > 0.0) {
                double ra = RADecConverter.getRADegrees((String)raChar);
                double dec = RADecConverter.getDecDegrees((String)decChar);
                if (this.getTab() == Tab.PULSAR) {
                    String pointCond = String.format("1=CONTAINS(s_point, CIRCLE('ICRS',%s,%s,%s/60))", ra, dec, radius);
                    this.addToWhere(pointCond);
                } else {
                    String table = this.getTab() == Tab.SIMPLE ? "a" : "df";
                    String pointCond = String.format(table + ".s_region IS NULL AND 1=CONTAINS(" + table + ".s_point, CIRCLE('ICRS',%s,%s,%s/60))", ra, dec, radius);
                    String regionCond = String.format(table + ".s_region IS NOT NULL AND 1=INTERSECTS(" + table + ".s_region, CIRCLE('ICRS',%s,%s,%s/60))", ra, dec, radius);
                    this.addToWhere(String.format("((%s) OR (%s))", pointCond, regionCond));
                }
            }
        }
    }

    private void appendVLBIWhere() {
        this.addToWhere("df.telescop = 'VLBIT'");
        this.addLikeCondition("df.piname", "piname", false, true);
        this.addCondition("df.telescop", "=", "telescop");
        this.addCondition("df.exptime", "=", "exptime");
        this.addAntennasCondition();
        this.addCondition("df.rate", "=", "exptime");
        this.addCondition("df.channels_vlbi", "=", "channels");
        this.addCondition("df.ch_resol", "=", "ch_resol");
    }

    private void addAntennasCondition() {
        List antennas;
        if (this.has("antennas") && !(antennas = (List)this.get("antennas", List.class)).isEmpty()) {
            ArrayList<CallSite> antennaConditions = new ArrayList<CallSite>();
            for (String antenna : antennas) {
                antennaConditions.add((CallSite)((Object)("df.antennas LIKE '%" + this.sanitizeForLike(antenna) + "%'")));
            }
            String mode = (String)this.get("antennas_query_mode", String.class);
            if ("AND".equals(mode) || "OR".equals(mode)) {
                this.addToWhere("(" + String.join((CharSequence)(" " + mode + " "), antennaConditions) + ")");
            } else {
                throw new IllegalArgumentException("Invalid antennas query mode value: " + mode);
            }
        }
    }

    private void appendSDWhere() {
        this.addToWhere("df.telescop <> 'VLBIT'");
        this.addCondition("df.telescop", "=", "telescop");
        this.addCondition("fe.frontend", "=", "frontend");
        this.addCondition("fe.backend", "=", "backend");
        this.addCondition("ad.bandwid", "=", "bandwid");
        this.addCondition("df.equinox", "=", "equinox");
        this.addCondition("df.exptime", "=", "exptime");
        this.addRangeCondition("df.lst", "lst");
        this.addCondition("df.scantype", "=", "scantype");
        this.addCondition("df.scanmode", "=", "scanmode");
        this.addCondition("df.scangeom", "=", "scangeom");
        this.addCondition("ss.usrframe", "=", "usrframe");
        this.addCondition("df.scanxvel", "=", "scanxvel");
        this.addCondition("fe.swtchmod", "=", "swtchmod");
        this.addCondition("ad.freqres", "=", "freqres");
        this.addCondition("ad.restfreq", "=", "restfreq");
        this.addCondition("bb.freq_bin", "=", "freq_bin");
        this.addCondition("df.wobused", "=", "wobused");
        this.addLikeCondition("df.obsid", "obsid", true, true);
        this.addLikeCondition("df.creator", "creator", true, true);
        this.addLikeCondition("df.fitsver", "fitsver", true, true);
    }

    private String formatDate(Object date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    private void addProgramCondition() {
        List groups;
        if (this.has("user_groups") && !this.has("program") && !(groups = (List)this.get("user_groups", List.class)).isEmpty()) {
            String programCol;
            switch (this.getTab()) {
                case SIMPLE: {
                    programCol = "a.program";
                    break;
                }
                case VLBI: 
                case SD: {
                    programCol = "df.projid";
                    break;
                }
                default: {
                    programCol = "projid";
                }
            }
            this.addToWhere(programCol + " IN(" + this.getSafeParamList(groups) + ")");
        }
    }

    private void addFrequencyCondition() {
        this.addCondition("ad.min_freq", ">=", "min_freq_min");
        this.addCondition("ad.max_freq", "<=", "max_freq_max");
    }

    private void addPulsarBackendCondition() {
        List backends;
        if (this.has("backend") && !(backends = (List)this.get("backend", List.class)).isEmpty()) {
            ArrayList<CallSite> backendConditions = new ArrayList<CallSite>();
            for (String backend : backends) {
                backendConditions.add((CallSite)((Object)("backend LIKE '%" + this.sanitizeForLike(backend) + "%'")));
            }
            this.addToWhere("(" + String.join((CharSequence)" OR ", backendConditions) + ")");
        }
    }
}

